/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.util;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.xun.lib.common.api.exceptions.UtilityClassException;
import net.xun.lib.common.api.inventory.InventoryCycleOrder;
import net.xun.lib.common.api.inventory.PlayerInventorySection;
import net.xun.lib.common.api.inventory.predicates.InventoryPredicate;
import net.xun.lib.common.api.util.InventoryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInventoryUtils {
    private PlayerInventoryUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static boolean hasEmptyHand(@NotNull class_1657 player) {
        PlayerInventoryUtils.validatePlayer(player);
        return player.method_6047().method_7960() || player.method_6079().method_7960();
    }

    public static boolean hasEmptyHand(@NotNull class_1657 player, class_1268 hand) {
        return player.method_5998(hand).method_7960();
    }

    public static boolean hasItemCount(class_1657 player, InventoryPredicate predicate, int minCount, PlayerInventorySection section) {
        return InventoryUtils.hasItemCount((class_1263)player.method_31548(), predicate, minCount, section.getSlotRange());
    }

    public static boolean hasItem(class_1657 player, InventoryPredicate predicate, PlayerInventorySection section) {
        return InventoryUtils.hasItem((class_1263)player.method_31548(), predicate, section.getSlotRange());
    }

    public static int findFirstMatchingSlot(class_1657 player, InventoryPredicate predicate, PlayerInventorySection section) {
        return InventoryUtils.findFirstMatchingSlot((class_1263)player.method_31548(), predicate, section.getSlotRange());
    }

    public static class_1799 getItemInSlot(class_1657 player, int slotIndex) {
        return InventoryUtils.getItemInSlot((class_1263)player.method_31548(), slotIndex);
    }

    public static void swapHands(@NotNull class_1657 player) {
        PlayerInventoryUtils.validatePlayer(player);
        class_1661 inventory = player.method_31548();
        class_1799 mainHandItem = player.method_6047();
        class_1799 offhandItem = player.method_6079();
        inventory.method_5447(class_1304.field_6173.method_5927(), offhandItem);
        inventory.method_5447(class_1304.field_6171.method_5927(), mainHandItem);
    }

    public static void setItemInMainHand(@NotNull class_1657 player, @NotNull class_1799 item) {
        PlayerInventoryUtils.validatePlayer(player);
        Objects.requireNonNull(item, "Item cannot be null");
        player.method_31548().method_5447(class_1304.field_6173.method_5927(), item);
    }

    public static void setItemInOffHand(@NotNull class_1657 player, @NotNull class_1799 item) {
        PlayerInventoryUtils.validatePlayer(player);
        Objects.requireNonNull(item, "Item cannot be null");
        player.method_31548().method_5447(class_1304.field_6171.method_5927(), item);
    }

    public static void clearBothHands(@NotNull class_1657 player) {
        PlayerInventoryUtils.validatePlayer(player);
        player.method_31548().method_5447(class_1304.field_6173.method_5927(), class_1799.field_8037);
        player.method_31548().method_5447(class_1304.field_6171.method_5927(), class_1799.field_8037);
    }

    public static void addItemToHands(@NotNull class_1657 player, @NotNull class_1799 item) {
        PlayerInventoryUtils.validatePlayer(player);
        Objects.requireNonNull(item, "Item cannot be null");
        if (PlayerInventoryUtils.hasEmptyHand(player, class_1268.field_5808)) {
            PlayerInventoryUtils.setItemInMainHand(player, item);
        } else if (PlayerInventoryUtils.hasEmptyHand(player, class_1268.field_5810)) {
            PlayerInventoryUtils.setItemInOffHand(player, item);
        }
    }

    public static void extractItems(class_1657 player, InventoryPredicate predicate, int amount, PlayerInventorySection section, InventoryCycleOrder order) {
        InventoryUtils.extractItems((class_1263)player.method_31548(), predicate, amount, section.getSlotRange(), order);
    }

    public static void extractSingleItem(class_1657 player, InventoryPredicate predicate, PlayerInventorySection section, InventoryCycleOrder order) {
        InventoryUtils.extractSingleItem((class_1263)player.method_31548(), predicate, section.getSlotRange(), order);
    }

    public static class_1799 insertItem(class_1657 player, class_1799 stack) {
        return InventoryUtils.insertItem((class_1263)player.method_31548(), stack);
    }

    public static void insertAndDiscardOverflow(class_1657 player, class_1799 stack) {
        InventoryUtils.insertAndDiscardOverflow((class_1263)player.method_31548(), stack);
    }

    public static ImmutableList<class_1799> collectMatching(class_1263 container, InventoryPredicate predicate, PlayerInventorySection section) {
        Objects.requireNonNull(section, "Section cannot be null");
        return InventoryUtils.collectMatching(container, predicate, section.getSlotRange());
    }

    public static int getAvailableSpace(class_1657 player) {
        return InventoryUtils.getAvailableSpace((class_1263)player.method_31548());
    }

    private static void validatePlayer(@Nullable class_1657 player) {
        Objects.requireNonNull(player, "Player cannot be null");
        InventoryUtils.validateContainer((class_1263)player.method_31548());
    }
}

