/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.world.effect;

import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_6880;
import net.xun.lib.common.api.util.MobEffectUtils;
import net.xun.lib.common.api.world.effect.EffectStackingStrategy;

public class MobEffectInstanceBuilder {
    private final class_6880<class_1291> effect;
    private int duration = 0;
    private int amplifier = 0;
    private boolean isAmbient = true;
    private boolean isVisible = true;
    private boolean showIcon = true;
    private EffectStackingStrategy strategy = EffectStackingStrategy.FORCE_OVERRIDE;

    public MobEffectInstanceBuilder(class_6880<class_1291> effect) {
        this.effect = effect;
    }

    public static MobEffectInstanceBuilder of(class_6880<class_1291> effect) {
        return new MobEffectInstanceBuilder(effect);
    }

    public MobEffectInstanceBuilder withDuration(int ticks) {
        this.duration = Math.max(0, ticks);
        return this;
    }

    public MobEffectInstanceBuilder withAmplifier(int amplifier) {
        this.amplifier = Math.max(0, Math.min(amplifier, 127));
        return this;
    }

    public MobEffectInstanceBuilder ambient() {
        this.isAmbient = true;
        return this;
    }

    public MobEffectInstanceBuilder hidden() {
        this.isVisible = false;
        return this;
    }

    public MobEffectInstanceBuilder hideIcon() {
        this.showIcon = false;
        return this;
    }

    public MobEffectInstanceBuilder withApplyStrategy(EffectStackingStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public class_1293 build() {
        return new class_1293(this.effect, this.duration, this.amplifier, this.isAmbient, this.isVisible, this.showIcon);
    }

    public void applyTo(class_1309 living) {
        if (living == null || living.method_37908().field_9236) {
            return;
        }
        MobEffectUtils.applyEffectsWithStrategy(living, List.of(this.build()), this.strategy);
    }
}

