/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.internal.block.entity;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.xun.lib.common.api.annotations.PersistentNbt;
import net.xun.lib.common.internal.nbt.NbtFieldAccessor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class BlockEntityDataManager {
    private static final Map<Class<?>, List<NbtFieldAccessor>> PERSIST_FIELDS = new ConcurrentHashMap();

    public static void savePersistedFields(class_2586 be, class_2487 tag) {
        Class<?> clazz = be.getClass();
        List fields = PERSIST_FIELDS.computeIfAbsent(clazz, k -> BlockEntityDataManager.scanFields(clazz, PersistentNbt.class));
        fields.forEach(f -> f.write(be, tag));
    }

    public static void loadPersistedFields(class_2586 be, class_2487 tag) {
        Class<?> clazz = be.getClass();
        List fields = PERSIST_FIELDS.computeIfAbsent(clazz, k -> BlockEntityDataManager.scanFields(clazz, PersistentNbt.class));
        fields.forEach(f -> f.load(be, tag));
    }

    public static List<NbtFieldAccessor> scanFields(Class<?> clazz, Class<? extends Annotation> annotation) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.isAnnotationPresent(annotation)).map(NbtFieldAccessor::new).collect(Collectors.toList());
    }
}

