/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.internal.misc;

import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ModIDManager {
    private static String modId = null;

    public static String getModId() {
        if (modId == null && (modId = ModIDManager.autoDetectModId()) == null) {
            throw new IllegalStateException("Mod ID not set and auto-detection failed. Call ModSetup.setModId() during mod initialization.");
        }
        return modId;
    }

    public static void setModId(String id) {
        if (id == null || id.isBlank()) {
            throw new IllegalArgumentException("Mod ID cannot not be null or empty");
        }
        modId = id.toLowerCase(Locale.ROOT);
    }

    private static String autoDetectModId() {
        try {
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                String className = element.getClassName();
                String packageName = Class.forName(className).getPackageName();
                String[] parts = packageName.split("\\.");
                if (parts.length < 2) continue;
                return parts[1];
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

