/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.internal.misc;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.xun.lib.common.api.annotations.PersistentNbt;
import net.xun.lib.common.internal.block.entity.BlockEntityDataManager;
import net.xun.lib.common.internal.nbt.NbtFieldAccessor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NbtUtils {
    public static class_2520 writeField(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot serialize null values");
        }
        if (value instanceof Number) {
            Number num;
            Number number = num = (Number)value;
            Objects.requireNonNull(number);
            Number number2 = number;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Byte.class, Short.class, Long.class, Float.class, Double.class}, (Object)number2, n)) {
                case 0: {
                    Integer i = (Integer)number2;
                    return class_2497.method_23247((int)num.intValue());
                }
                case 1: {
                    Byte b = (Byte)number2;
                    return class_2481.method_23233((byte)num.byteValue());
                }
                case 2: {
                    Short i = (Short)number2;
                    return class_2516.method_23254((short)num.shortValue());
                }
                case 3: {
                    Long l = (Long)number2;
                    return class_2503.method_23251((long)num.longValue());
                }
                case 4: {
                    Float v = (Float)number2;
                    return class_2494.method_23244((float)num.floatValue());
                }
                case 5: {
                    Double v = (Double)number2;
                    return class_2489.method_23241((double)num.doubleValue());
                }
            }
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return class_2481.method_23233((byte)(bool != false ? (byte)1 : 0));
        }
        if (value instanceof String) {
            String str = (String)value;
            return class_2519.method_23256((String)str);
        }
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            class_2487 uuidTag = new class_2487();
            uuidTag.method_10544("MostSig", uuid.getMostSignificantBits());
            uuidTag.method_10544("LeastSig", uuid.getLeastSignificantBits());
            return uuidTag;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return new class_2479(bytes);
        }
        if (value instanceof int[]) {
            int[] ints = (int[])value;
            return new class_2495(ints);
        }
        if (value instanceof long[]) {
            long[] longs = (long[])value;
            return new class_2501(longs);
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            class_2499 list = new class_2499();
            for (Object element : iterable) {
                list.add((Object)NbtUtils.writeField(element));
            }
            return list;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            class_2487 compound = new class_2487();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Map keys must be strings");
                }
                compound.method_10566((String)key, NbtUtils.writeField(entry.getValue()));
            }
            return compound;
        }
        try {
            class_2487 objectTag = new class_2487();
            List<NbtFieldAccessor> fields = BlockEntityDataManager.scanFields(value.getClass(), PersistentNbt.class);
            for (NbtFieldAccessor field : fields) {
                Object fieldValue = field.getGetter().invoke(value);
                objectTag.method_10566(field.getField().getName(), NbtUtils.writeField(fieldValue));
            }
            return objectTag;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
        }
    }

    public static Object readField(class_2520 tag) {
        if (tag instanceof class_2514) {
            class_2514 num = (class_2514)tag;
            class_2520 class_25202 = tag;
            Objects.requireNonNull(class_25202);
            class_2520 class_25203 = class_25202;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2497.class, class_2481.class, class_2516.class, class_2503.class, class_2494.class, class_2489.class}, (Object)class_25203, n)) {
                case 0: {
                    class_2497 intTag = (class_2497)class_25203;
                    return num.method_10701();
                }
                case 1: {
                    class_2481 byteTag = (class_2481)class_25203;
                    return num.method_10698();
                }
                case 2: {
                    class_2516 shortTag = (class_2516)class_25203;
                    return num.method_10696();
                }
                case 3: {
                    class_2503 longTag = (class_2503)class_25203;
                    return num.method_10699();
                }
                case 4: {
                    class_2494 floatTag = (class_2494)class_25203;
                    return Float.valueOf(num.method_10700());
                }
                case 5: {
                    class_2489 doubleTag = (class_2489)class_25203;
                    return num.method_10697();
                }
            }
        }
        if (tag instanceof class_2519) {
            class_2519 str = (class_2519)tag;
            return str.method_10714();
        }
        if (tag instanceof class_2479) {
            class_2479 bat = (class_2479)tag;
            return bat.method_10521();
        }
        if (tag instanceof class_2495) {
            class_2495 iat = (class_2495)tag;
            return iat.method_10588();
        }
        if (tag instanceof class_2501) {
            class_2501 lat = (class_2501)tag;
            return lat.method_10615();
        }
        if (tag instanceof class_2487) {
            class_2487 compound = (class_2487)tag;
            if (compound.method_10573("MostSig", 4) && compound.method_10573("LeastSig", 4)) {
                return new UUID(compound.method_10537("MostSig"), compound.method_10537("LeastSig"));
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : compound.method_10541()) {
                map.put(key, NbtUtils.readField(compound.method_10580(key)));
            }
            return map;
        }
        if (tag instanceof class_2499) {
            class_2499 list = (class_2499)tag;
            ArrayList<Object> result = new ArrayList<Object>();
            for (class_2520 element : list) {
                result.add(NbtUtils.readField(element));
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported tag type: " + tag.getClass().getName());
    }
}

