/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.internal.nbt;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import net.xun.lib.common.api.nbt.INbtAdapter;
import net.xun.lib.common.api.nbt.adapters.GenericNbtAdapter;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NbtAdapterCache {
    public static final Map<Class<?>, INbtAdapter<?>> ADAPTERS = new ConcurrentHashMap();
    public static volatile boolean initialized = false;

    public static INbtAdapter<?> findAdapter(Class<?> type) {
        if (!initialized) {
            NbtAdapterCache.initialize();
        }
        return ADAPTERS.getOrDefault(type, new GenericNbtAdapter());
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        ServiceLoader<INbtAdapter> loader = ServiceLoader.load(INbtAdapter.class);
        for (INbtAdapter adapter : loader) {
            Class targetType = adapter.getTargetType();
            if (ADAPTERS.containsKey(targetType)) {
                throw new IllegalStateException("Duplicate adapter for: " + targetType.getName());
            }
            ADAPTERS.put(targetType, adapter);
        }
        initialized = true;
    }
}

