/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.internal.nbt;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_8909;
import net.xun.lib.common.api.nbt.INbtAdapter;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NbtFieldAccessor {
    private final Field field;
    private final MethodHandle getter;
    private final MethodHandle setter;
    private final INbtAdapter<Object> adapter;

    public NbtFieldAccessor(Field field) {
        this.field = field;
        field.setAccessible(true);
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            this.getter = lookup.unreflectGetter(field);
            this.setter = lookup.unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to access field: " + field.getName(), e);
        }
        Class<?> fieldType = field.getType();
        this.adapter = INbtAdapter.getAdapterFor(fieldType);
    }

    public void write(Object instance, class_2487 tag) {
        try {
            Object value = this.getter.invoke(instance);
            class_2520 savedTag = this.adapter.save(value);
            tag.method_10566(this.field.getName(), savedTag);
        }
        catch (Throwable e) {
            throw new class_8909("Failed to write field: " + this.field.getName());
        }
    }

    public void load(Object instance, class_2487 tag) {
        try {
            String fieldName = this.field.getName();
            if (tag.method_10545(fieldName)) {
                class_2520 valueTag = tag.method_10580(fieldName);
                Object value = this.adapter.load(valueTag);
                this.setter.invoke(instance, value);
            }
        }
        catch (Throwable e) {
            throw new class_8909("Failed to load field: " + this.field.getName());
        }
    }

    public Field getField() {
        return this.field;
    }

    public MethodHandle getGetter() {
        return this.getter;
    }

    public MethodHandle getSetter() {
        return this.setter;
    }

    public INbtAdapter<Object> getAdapter() {
        return this.adapter;
    }
}

