package net.xun.lib.common.api.registries;

import net.minecraft.world.item.Item;

import java.util.function.Supplier;

public class LazyItemReference<T extends Item> {

    private final String id;
    private final Supplier<T> supplier;
    private T resolved;

    public LazyItemReference(String id, Supplier<T> supplier) {
        this.id = id;
        this.supplier = supplier;
    }

    public String getId() {
        return id;
    }

    public T get() {
        if (resolved == null) {
            resolved = supplier.get();
        }
        return resolved;
    }
}
