package net.ankrya.kamenridergavv.mixins;

import org.spongepowered.asm.mixin.Mixin;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.Cancellable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.ankrya.kamenridergavv.network.KamenridergavvModVariables;

@Mixin(PlayerRenderer.class)
public abstract class PlayerRenderMixin extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>{



		public PlayerRenderMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> entityModel, float f) {
        	super(context, entityModel, f);
    	}

		
	@Inject(method = {"setModelProperties"}, at = {@At("TAIL")},cancellable = true)
    private void setModelPropertiesMixin(AbstractClientPlayer p_117819_ , CallbackInfo ci){
    		boolean stealth = p_117819_.getCapability(KamenridergavvModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse(new KamenridergavvModVariables.PlayerVariables()).Invisibility;
    		if (stealth) {
	    		this.getModel().setAllVisible(false);
	    		
    		ci.cancel();
		}
    }
}