/*
 * Decompiled with CFR 0.152.
 */
package gold.eggs.commandblockspy;

import gold.eggs.commandblockspy.CommandBlockInfo;
import gold.eggs.commandblockspy.ConfigManager;
import gold.eggs.commandblockspy.DatabaseManager;
import gold.eggs.commandblockspy.I18nManager;
import gold.eggs.commandblockspy.MainPlugin;
import gold.eggs.commandblockspy.UtilsKt;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0007J@\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0015"}, d2={"Lgold/eggs/commandblockspy/CbSpyListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "commandBlockMonitor", "", "event", "Lorg/bukkit/event/server/ServerCommandEvent;", "commandBlockInterceptor", "onMinecartCreate", "Lorg/bukkit/event/vehicle/VehicleCreateEvent;", "sendMessageWithLocation", "player", "Lorg/bukkit/entity/Player;", "messageKey", "", "placeholders", "", "info", "Lgold/eggs/commandblockspy/CommandBlockInfo;", "prefixKey", "command-block-spy"})
@SourceDebugExtension(value={"SMAP\nCbSpyListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CbSpyListener.kt\ngold/eggs/commandblockspy/CbSpyListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n1#2:228\n*E\n"})
public final class CbSpyListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public final void commandBlockMonitor(@NotNull ServerCommandEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        CommandBlockInfo commandBlockInfo = UtilsKt.extractCommandBlockInfo(event);
        if (commandBlockInfo == null) {
            return;
        }
        CommandBlockInfo info = commandBlockInfo;
        if (!event.isCancelled() && ConfigManager.INSTANCE.getDatabaseLoggingEnabled()) {
            DatabaseManager.INSTANCE.recordCommandExecution(info.getCommand(), info.getLocation());
        }
        if (ConfigManager.INSTANCE.getBackendMonitorEnabled()) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("type", info.getType()), TuplesKt.to("world", info.getWorldName()), TuplesKt.to("x", String.valueOf(info.getX())), TuplesKt.to("y", String.valueOf(info.getY())), TuplesKt.to("z", String.valueOf(info.getZ())), TuplesKt.to("command", info.getCommand())};
            MainPlugin.Companion.getInstance().getLogger().info(I18nManager.INSTANCE.get("monitor.execution.console", MapsKt.mapOf(pairArray)));
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            if (!ConfigManager.INSTANCE.isPlayerMonitoring(uUID)) continue;
            Intrinsics.checkNotNull(player);
            Pair[] pairArray = new Pair[]{TuplesKt.to("type", info.getType()), TuplesKt.to("command", info.getCommand())};
            this.sendMessageWithLocation(player, "monitor.execution.player", MapsKt.mapOf(pairArray), info, null);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void commandBlockInterceptor(@NotNull ServerCommandEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ConfigManager.INSTANCE.getBanCommandMinecart() && event.getSender() instanceof CommandMinecart) {
            CommandSender commandSender = event.getSender();
            Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Entity");
            Entity sender = (Entity)commandSender;
            event.setCancelled(true);
            sender.remove();
            Location location = sender.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            Location location2 = location;
            Pair[] pairArray = new Pair[]{TuplesKt.to("world", location2.getWorld().getName()), TuplesKt.to("x", String.valueOf(location2.getBlockX())), TuplesKt.to("y", String.valueOf(location2.getBlockY())), TuplesKt.to("z", String.valueOf(location2.getBlockZ()))};
            MainPlugin.Companion.getInstance().getLogger().info(I18nManager.INSTANCE.get("intercept.minecart.console", MapsKt.mapOf(pairArray)));
            return;
        }
        CommandBlockInfo commandBlockInfo = UtilsKt.extractCommandBlockInfo(event);
        if (commandBlockInfo == null) {
            return;
        }
        CommandBlockInfo info = commandBlockInfo;
        if (ConfigManager.INSTANCE.getInterceptRepeatingAuto() && info.getBlock().getType() == Material.REPEATING_COMMAND_BLOCK && Intrinsics.areEqual(UtilsKt.getAuto(info.getCommandBlock()), true)) {
            UtilsKt.setAuto(info.getCommandBlock(), false);
            event.setCancelled(true);
            for (Player player : Bukkit.getOnlinePlayers()) {
                Intrinsics.checkNotNull(player);
                CbSpyListener.sendMessageWithLocation$default(this, player, "intercept.repeating.player", MapsKt.emptyMap(), info, null, 16, null);
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to("world", info.getWorldName()), TuplesKt.to("x", String.valueOf(info.getX())), TuplesKt.to("y", String.valueOf(info.getY())), TuplesKt.to("z", String.valueOf(info.getZ())), TuplesKt.to("command", info.getCommand())};
            MainPlugin.Companion.getInstance().getLogger().info(I18nManager.INSTANCE.get("intercept.repeating.console", MapsKt.mapOf(pairArray)));
            return;
        }
        if (ConfigManager.INSTANCE.getRegexInterceptEnabled()) {
            for (Map.Entry<Regex, String> entry : ConfigManager.INSTANCE.getRegexBlockList().entrySet()) {
                Regex regex = entry.getKey();
                String reason = entry.getValue();
                if (!regex.containsMatchIn(info.getCommand())) continue;
                event.setCancelled(true);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Intrinsics.checkNotNull(player);
                    CbSpyListener.sendMessageWithLocation$default(this, player, "intercept.pattern.player", MapsKt.mapOf(TuplesKt.to("reason", reason)), info, null, 16, null);
                }
                Pair[] pairArray = new Pair[]{TuplesKt.to("reason", reason), TuplesKt.to("world", info.getWorldName()), TuplesKt.to("x", String.valueOf(info.getX())), TuplesKt.to("y", String.valueOf(info.getY())), TuplesKt.to("z", String.valueOf(info.getZ())), TuplesKt.to("command", info.getCommand())};
                MainPlugin.Companion.getInstance().getLogger().info(I18nManager.INSTANCE.get("intercept.pattern.console", MapsKt.mapOf(pairArray)));
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onMinecartCreate(@NotNull VehicleCreateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!ConfigManager.INSTANCE.getBanCommandMinecart()) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        Intrinsics.checkNotNullExpressionValue(vehicle, "getVehicle(...)");
        Vehicle entity = vehicle;
        if (entity instanceof CommandMinecart) {
            event.setCancelled(true);
            String msg = I18nManager.INSTANCE.get("intercept.minecart.player", MapsKt.mapOf(TuplesKt.to("location", ((CommandMinecart)entity).getLocation().getWorld().getName() + ", " + ((CommandMinecart)entity).getLocation().getBlockX() + ", " + ((CommandMinecart)entity).getLocation().getBlockY() + ", " + ((CommandMinecart)entity).getLocation().getBlockZ())));
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage((Component)Component.text((String)I18nManager.INSTANCE.get("prefix.cbspy.player", MapsKt.mapOf(TuplesKt.to("msg", msg)))));
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to("world", ((CommandMinecart)entity).getLocation().getWorld().getName()), TuplesKt.to("x", String.valueOf(((CommandMinecart)entity).getLocation().getBlockX())), TuplesKt.to("y", String.valueOf(((CommandMinecart)entity).getLocation().getBlockY())), TuplesKt.to("z", String.valueOf(((CommandMinecart)entity).getLocation().getBlockZ()))};
            MainPlugin.Companion.getInstance().getLogger().info(I18nManager.INSTANCE.get("intercept.minecart.console", MapsKt.mapOf(pairArray)));
        }
    }

    public final void sendMessageWithLocation(@NotNull Player player, @NotNull String messageKey, @NotNull Map<String, String> placeholders, @NotNull CommandBlockInfo info, @Nullable String prefixKey) {
        TextComponent.Builder builder;
        Object object;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(messageKey, "messageKey");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        Intrinsics.checkNotNullParameter(info, "info");
        String raw = I18nManager.INSTANCE.get(messageKey, MapsKt.plus(placeholders, TuplesKt.to("location", "{location}")));
        String[] stringArray = new String[]{"{location}"};
        List parts = StringsKt.split$default((CharSequence)raw, stringArray, false, 2, 2, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to("world", info.getWorldName()), TuplesKt.to("x", String.valueOf(info.getX())), TuplesKt.to("y", String.valueOf(info.getY())), TuplesKt.to("z", String.valueOf(info.getZ()))};
        Component component = ((TextComponent)Component.text((String)I18nManager.INSTANCE.get("location", MapsKt.mapOf(pairArray))).clickEvent(ClickEvent.runCommand((String)("/tp @s " + info.getX() + " " + info.getY() + " " + info.getZ())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((Component)Component.text((String)I18nManager.get$default(I18nManager.INSTANCE, "tp.hover_event", null, 2, null)))));
        Intrinsics.checkNotNullExpressionValue(component, "hoverEvent(...)");
        TextComponent locationComponent = (TextComponent)component;
        TextComponent.Builder builder2 = (TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)((String)parts.get(0))))).append((Component)locationComponent);
        List list = parts;
        int n = 1;
        if (n < list.size()) {
            object = list.get(n);
        } else {
            int n2 = n;
            builder = builder2;
            boolean bl = false;
            object = "";
            builder2 = builder;
        }
        ComponentBuilder componentBuilder = builder2.append((Component)Component.text((String)((String)object)));
        Intrinsics.checkNotNullExpressionValue(componentBuilder, "append(...)");
        TextComponent.Builder messageComponent = (TextComponent.Builder)componentBuilder;
        if (prefixKey == null) {
            player.sendMessage((ComponentLike)messageComponent);
        } else {
            Object object2;
            String prefixRaw = I18nManager.INSTANCE.get(prefixKey, MapsKt.mapOf(TuplesKt.to("msg", "__MSG__")));
            String[] stringArray2 = new String[]{"__MSG__"};
            List prefixParts = StringsKt.split$default((CharSequence)prefixRaw, stringArray2, false, 2, 2, null);
            TextComponent.Builder builder3 = (TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)((String)prefixParts.get(0))))).append((ComponentBuilder)messageComponent);
            int n3 = 1;
            List list2 = prefixParts;
            if (n3 < list2.size()) {
                object2 = list2.get(n3);
            } else {
                int n4 = n3;
                builder = builder3;
                boolean bl = false;
                object2 = "";
                builder3 = builder;
            }
            ComponentBuilder componentBuilder2 = builder3.append((Component)Component.text((String)((String)object2)));
            Intrinsics.checkNotNullExpressionValue(componentBuilder2, "append(...)");
            TextComponent.Builder prefixComponent = (TextComponent.Builder)componentBuilder2;
            player.sendMessage((ComponentLike)prefixComponent);
        }
    }

    public static /* synthetic */ void sendMessageWithLocation$default(CbSpyListener cbSpyListener, Player player, String string, Map map, CommandBlockInfo commandBlockInfo, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            string2 = "prefix.cbspy.player";
        }
        cbSpyListener.sendMessageWithLocation(player, string, map, commandBlockInfo, string2);
    }
}

