/*
 * Decompiled with CFR 0.152.
 */
package gold.eggs.commandblockspy;

import gold.eggs.commandblockspy.MainPlugin;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020%J\u000e\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020#J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010*\u001a\u00020#R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lgold/eggs/commandblockspy/ConfigManager;", "", "<init>", "()V", "databaseLoggingEnabled", "", "getDatabaseLoggingEnabled", "()Z", "setDatabaseLoggingEnabled", "(Z)V", "backendMonitorEnabled", "getBackendMonitorEnabled", "setBackendMonitorEnabled", "interceptRepeatingAuto", "getInterceptRepeatingAuto", "setInterceptRepeatingAuto", "banCommandMinecart", "getBanCommandMinecart", "setBanCommandMinecart", "regexInterceptEnabled", "getRegexInterceptEnabled", "setRegexInterceptEnabled", "regexBlockList", "", "Lkotlin/text/Regex;", "", "getRegexBlockList", "()Ljava/util/Map;", "language", "getLanguage", "()Ljava/lang/String;", "setLanguage", "(Ljava/lang/String;)V", "monitoringPlayers", "", "Ljava/util/UUID;", "load", "", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "save", "togglePlayerMonitoring", "uuid", "isPlayerMonitoring", "command-block-spy"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    private static boolean databaseLoggingEnabled;
    private static boolean backendMonitorEnabled;
    private static boolean interceptRepeatingAuto;
    private static boolean banCommandMinecart;
    private static boolean regexInterceptEnabled;
    @NotNull
    private static final Map<Regex, String> regexBlockList;
    @NotNull
    private static String language;
    @NotNull
    private static final Set<UUID> monitoringPlayers;

    private ConfigManager() {
    }

    public final boolean getDatabaseLoggingEnabled() {
        return databaseLoggingEnabled;
    }

    public final void setDatabaseLoggingEnabled(boolean bl) {
        databaseLoggingEnabled = bl;
    }

    public final boolean getBackendMonitorEnabled() {
        return backendMonitorEnabled;
    }

    public final void setBackendMonitorEnabled(boolean bl) {
        backendMonitorEnabled = bl;
    }

    public final boolean getInterceptRepeatingAuto() {
        return interceptRepeatingAuto;
    }

    public final void setInterceptRepeatingAuto(boolean bl) {
        interceptRepeatingAuto = bl;
    }

    public final boolean getBanCommandMinecart() {
        return banCommandMinecart;
    }

    public final void setBanCommandMinecart(boolean bl) {
        banCommandMinecart = bl;
    }

    public final boolean getRegexInterceptEnabled() {
        return regexInterceptEnabled;
    }

    public final void setRegexInterceptEnabled(boolean bl) {
        regexInterceptEnabled = bl;
    }

    @NotNull
    public final Map<Regex, String> getRegexBlockList() {
        return regexBlockList;
    }

    @NotNull
    public final String getLanguage() {
        return language;
    }

    public final void setLanguage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        language = string;
    }

    public final void load(@NotNull FileConfiguration config) {
        Intrinsics.checkNotNullParameter(config, "config");
        databaseLoggingEnabled = config.getBoolean("database-logging-enabled", false);
        backendMonitorEnabled = config.getBoolean("backend-monitor-enabled", false);
        interceptRepeatingAuto = config.getBoolean("intercept-repeating-auto", false);
        banCommandMinecart = config.getBoolean("ban-command-minecart", false);
        regexInterceptEnabled = config.getBoolean("regex-intercept-enabled", false);
        String string = config.getString("language", "zh_CN");
        if (string == null) {
            string = "zh_CN";
        }
        language = string;
        regexBlockList.clear();
        List list = config.getMapList("regex-block-list");
        Intrinsics.checkNotNullExpressionValue(list, "getMapList(...)");
        List list2 = list;
        for (Map entry : list2) {
            Intrinsics.checkNotNull(entry);
            Object v = entry.get("pattern");
            if (v == null || (v = v.toString()) == null) continue;
            Object pattern = v;
            Object v2 = entry.get("message");
            if (v2 == null || (v2 = v2.toString()) == null) continue;
            Object message = v2;
            try {
                Regex regex = new Regex((String)pattern);
                regexBlockList.put(regex, (String)message);
            }
            catch (Exception e) {
                System.out.println((Object)("Invalid regex in config: " + pattern));
                System.out.println((Object)("Error: " + e.getMessage()));
            }
        }
    }

    public final void save() {
        MainPlugin plugin = MainPlugin.Companion.getInstance();
        FileConfiguration fileConfiguration = plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        FileConfiguration config = fileConfiguration;
        config.set("database-logging-enabled", (Object)databaseLoggingEnabled);
        config.set("backend-monitor-enabled", (Object)backendMonitorEnabled);
        config.set("intercept-repeating-auto", (Object)interceptRepeatingAuto);
        config.set("ban-command-minecart", (Object)banCommandMinecart);
        config.set("regex-intercept-enabled", (Object)regexInterceptEnabled);
        plugin.saveConfig();
    }

    public final boolean togglePlayerMonitoring(@NotNull UUID uuid) {
        boolean bl;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        if (monitoringPlayers.contains(uuid)) {
            monitoringPlayers.remove(uuid);
            bl = false;
        } else {
            monitoringPlayers.add(uuid);
            bl = true;
        }
        return bl;
    }

    public final boolean isPlayerMonitoring(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return monitoringPlayers.contains(uuid);
    }

    static {
        regexBlockList = new LinkedHashMap();
        language = "zh_CN";
        monitoringPlayers = new LinkedHashSet();
    }
}

