/*
 * Decompiled with CFR 0.152.
 */
package gold.eggs.commandblockspy;

import gold.eggs.commandblockspy.CommandRecord;
import gold.eggs.commandblockspy.MainPlugin;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgold/eggs/commandblockspy/DatabaseManager;", "", "<init>", "()V", "connection", "Ljava/sql/Connection;", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "init", "", "recordCommandExecution", "cmd", "", "loc", "Lorg/bukkit/Location;", "queryByLocation", "Lgold/eggs/commandblockspy/CommandRecord;", "queryRecentExecutions", "", "limit", "", "resultToRecord", "rs", "Ljava/sql/ResultSet;", "close", "command-block-spy"})
public final class DatabaseManager {
    @NotNull
    public static final DatabaseManager INSTANCE = new DatabaseManager();
    private static Connection connection;
    private static final DateTimeFormatter dateFormat;

    private DatabaseManager() {
    }

    public final void init() {
        File dbFile = new File(MainPlugin.Companion.getInstance().getDataFolder(), "cbspy.db");
        dbFile.getParentFile().mkdirs();
        connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
        Connection connection = DatabaseManager.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        Statement stmt = connection.createStatement();
        stmt.executeUpdate("\n            CREATE TABLE IF NOT EXISTS command_executions (\n                command TEXT,\n                world TEXT,\n                x INT,\n                y INT,\n                z INT,\n                execution_count INT,\n                last_execution TEXT,\n                PRIMARY KEY (world, x, y, z)\n            )\n            ");
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordCommandExecution(@NotNull String cmd, @NotNull Location loc) {
        Intrinsics.checkNotNullParameter(cmd, "cmd");
        Intrinsics.checkNotNullParameter(loc, "loc");
        String now = LocalDateTime.now().format(dateFormat);
        String sql = "\n            INSERT INTO command_executions (command, world, x, y, z, execution_count, last_execution)\n            VALUES (?, ?, ?, ?, ?, 1, ?)\n            ON CONFLICT(world, x, y, z)\n            DO UPDATE SET\n                execution_count = execution_count + 1,\n                command = excluded.command,\n                last_execution = excluded.last_execution\n        ";
        Connection connection = DatabaseManager.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        AutoCloseable autoCloseable = connection.prepareStatement(sql);
        Throwable throwable = null;
        try {
            PreparedStatement ps = (PreparedStatement)autoCloseable;
            boolean bl = false;
            ps.setString(1, cmd);
            ps.setString(2, loc.getWorld().getName());
            ps.setInt(3, loc.getBlockX());
            ps.setInt(4, loc.getBlockY());
            ps.setInt(5, loc.getBlockZ());
            ps.setString(6, now);
            int n = ps.executeUpdate();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final CommandRecord queryByLocation(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        String sql = "\n            SELECT * FROM command_executions WHERE world = ? AND x = ? AND y = ? AND z = ?\n        ";
        Connection connection = DatabaseManager.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        AutoCloseable autoCloseable = connection.prepareStatement(sql);
        Throwable throwable = null;
        try {
            CommandRecord commandRecord;
            PreparedStatement ps = (PreparedStatement)autoCloseable;
            boolean bl = false;
            ps.setString(1, loc.getWorld().getName());
            ps.setInt(2, loc.getBlockX());
            ps.setInt(3, loc.getBlockY());
            ps.setInt(4, loc.getBlockZ());
            AutoCloseable autoCloseable2 = ps.executeQuery();
            Throwable throwable2 = null;
            try {
                CommandRecord commandRecord2;
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                if (rs.next()) {
                    Intrinsics.checkNotNull(rs);
                    commandRecord2 = INSTANCE.resultToRecord(rs);
                } else {
                    commandRecord2 = null;
                }
                commandRecord = commandRecord2;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            CommandRecord commandRecord3 = commandRecord;
            return commandRecord3;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<CommandRecord> queryRecentExecutions(int limit) {
        String sql = "\n            SELECT * FROM command_executions ORDER BY last_execution DESC LIMIT ?\n        ";
        Connection connection = DatabaseManager.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        AutoCloseable autoCloseable = connection.prepareStatement(sql);
        Throwable throwable = null;
        try {
            List list;
            PreparedStatement ps = (PreparedStatement)autoCloseable;
            boolean bl = false;
            ps.setInt(1, limit);
            AutoCloseable autoCloseable2 = ps.executeQuery();
            Throwable throwable2 = null;
            try {
                ResultSet rs = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                List result = new ArrayList();
                while (rs.next()) {
                    Intrinsics.checkNotNull(rs);
                    result.add(INSTANCE.resultToRecord(rs));
                }
                list = result;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            List list2 = list;
            return list2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private final CommandRecord resultToRecord(ResultSet rs) {
        String string = rs.getString("command");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string2 = rs.getString("world");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        int n = rs.getInt("x");
        int n2 = rs.getInt("y");
        int n3 = rs.getInt("z");
        int n4 = rs.getInt("execution_count");
        String string3 = rs.getString("last_execution");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        return new CommandRecord(string, string2, n, n2, n3, n4, string3);
    }

    public final void close() {
        if (connection != null) {
            Connection connection = DatabaseManager.connection;
            if (connection == null) {
                Intrinsics.throwUninitializedPropertyAccessException("connection");
                connection = null;
            }
            if (!connection.isClosed()) {
                Connection connection2 = DatabaseManager.connection;
                if (connection2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("connection");
                    connection2 = null;
                }
                connection2.close();
            }
        }
    }

    static {
        dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }
}

