/*
 * Decompiled with CFR 0.152.
 */
package gold.eggs.commandblockspy;

import gold.eggs.commandblockspy.CommandRecord;
import gold.eggs.commandblockspy.ConfigManager;
import gold.eggs.commandblockspy.DatabaseManager;
import gold.eggs.commandblockspy.I18nManager;
import gold.eggs.commandblockspy.MainPlugin;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lgold/eggs/commandblockspy/MonitorCommand;", "Lorg/bukkit/command/CommandExecutor;", "<init>", "()V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "parseIntArg", "", "arg", "name", "(Ljava/lang/String;Ljava/lang/String;Lorg/bukkit/command/CommandSender;)Ljava/lang/Integer;", "command-block-spy"})
public final class MonitorCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String msg;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 0) {
            if (!sender.hasPermission("cbspy.use")) {
                sender.sendMessage(I18nManager.get$default(I18nManager.INSTANCE, "command.no_permission", null, 2, null));
                return true;
            }
            CommandSender commandSender = sender;
            if (commandSender instanceof Player) {
                UUID uUID = ((Player)sender).getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                boolean enabled = ConfigManager.INSTANCE.togglePlayerMonitoring(uUID);
                msg = enabled ? I18nManager.get$default(I18nManager.INSTANCE, "command.cbspy.on.player", null, 2, null) : I18nManager.get$default(I18nManager.INSTANCE, "command.cbspy.off.player", null, 2, null);
                sender.sendMessage(I18nManager.INSTANCE.get("prefix.cbspy.player", MapsKt.mapOf(TuplesKt.to("msg", msg))));
            } else if (commandSender instanceof ConsoleCommandSender) {
                ConfigManager.INSTANCE.setBackendMonitorEnabled(!ConfigManager.INSTANCE.getBackendMonitorEnabled());
                ConfigManager.INSTANCE.save();
                String msg2 = ConfigManager.INSTANCE.getBackendMonitorEnabled() ? I18nManager.get$default(I18nManager.INSTANCE, "command.cbspy.on.console", null, 2, null) : I18nManager.get$default(I18nManager.INSTANCE, "command.cbspy.off.console", null, 2, null);
                sender.sendMessage(I18nManager.INSTANCE.get("prefix.cbspy.console", MapsKt.mapOf(TuplesKt.to("msg", msg2))));
            } else {
                sender.sendMessage(I18nManager.get$default(I18nManager.INSTANCE, "command.invalid_sender", null, 2, null));
            }
        }
        if (!(args.length == 0)) {
            if (StringsKt.equals(args[0], "reload", true)) {
                if (!sender.hasPermission("cbspy.reload")) {
                    sender.sendMessage(I18nManager.get$default(I18nManager.INSTANCE, "command.no_permission", null, 2, null));
                    return true;
                }
                MainPlugin plugin = MainPlugin.Companion.getInstance();
                plugin.reloadConfig();
                FileConfiguration fileConfiguration = plugin.getConfig();
                Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
                ConfigManager.INSTANCE.load(fileConfiguration);
                I18nManager.INSTANCE.init(ConfigManager.INSTANCE.getLanguage(), plugin);
                String msg3 = I18nManager.get$default(I18nManager.INSTANCE, "command.cbspy.reload.success", null, 2, null);
                sender.sendMessage(I18nManager.INSTANCE.get("prefix.cbspy.player", MapsKt.mapOf(TuplesKt.to("msg", msg3))));
                return true;
            }
            if (ConfigManager.INSTANCE.getDatabaseLoggingEnabled()) {
                if (args.length >= 2 && StringsKt.equals(args[0], "query", true) && StringsKt.equals(args[1], "recent", true)) {
                    if (!sender.hasPermission("cbspy.query")) {
                        sender.sendMessage(I18nManager.get$default(I18nManager.INSTANCE, "command.no_permission", null, 2, null));
                        return true;
                    }
                    Object object = ArraysKt.getOrNull(args, 2);
                    int limit = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 5;
                    List<CommandRecord> results = DatabaseManager.INSTANCE.queryRecentExecutions(limit);
                    msg = I18nManager.INSTANCE.get("command.cbspy.query.recent", MapsKt.mapOf(TuplesKt.to("limit", String.valueOf(limit))));
                    sender.sendMessage(I18nManager.INSTANCE.get("prefix.cbspy.player", MapsKt.mapOf(TuplesKt.to("msg", msg))));
                    Iterator iterator2 = ((Iterable)results).iterator();
                    int n = 0;
                    while (iterator2.hasNext()) {
                        int i = n++;
                        CommandRecord row = (CommandRecord)iterator2.next();
                        sender.sendMessage(((TextComponent)Component.text((String)("\u00a77" + (i + 1) + ". \u00a7f" + row.getCommand() + " ")).append(((TextComponent)Component.text((String)("\u00a77@ (" + row.getX() + "," + row.getY() + "," + row.getZ() + ")")).clickEvent(ClickEvent.runCommand((String)("/tp @s " + row.getX() + " " + row.getY() + " " + row.getZ())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((Component)Component.text((String)I18nManager.get$default(I18nManager.INSTANCE, "tp.hover_event", null, 2, null))))))).append((Component)Component.text((String)(" \u00a78" + row.getLastExecution()))));
                    }
                    return true;
                }
                if (args.length == 5 && StringsKt.equals(args[0], "query", true) && StringsKt.equals(args[1], "loc", true)) {
                    if (!sender.hasPermission("cbspy.query")) {
                        sender.sendMessage(I18nManager.get$default(I18nManager.INSTANCE, "command.no_permission", null, 2, null));
                        return true;
                    }
                    Integer n = this.parseIntArg(args[2], "X", sender);
                    if (n == null) {
                        return true;
                    }
                    int x = n;
                    Integer n2 = this.parseIntArg(args[3], "Y", sender);
                    if (n2 == null) {
                        return true;
                    }
                    int y = n2;
                    Integer n3 = this.parseIntArg(args[4], "Z", sender);
                    if (n3 == null) {
                        return true;
                    }
                    int z = n3;
                    World world = Bukkit.getWorld((String)"world");
                    Location loc = new Location(world, (double)x, (double)y, (double)z);
                    CommandRecord record = DatabaseManager.INSTANCE.queryByLocation(loc);
                    if (record != null) {
                        String msg4 = I18nManager.get$default(I18nManager.INSTANCE, "command.cbspy.query.loc.msg", null, 2, null);
                        sender.sendMessage(I18nManager.INSTANCE.get("prefix.cbspy.player", MapsKt.mapOf(TuplesKt.to("msg", msg4))));
                        sender.sendMessage(I18nManager.INSTANCE.get("command.cbspy.query.loc.command", MapsKt.mapOf(TuplesKt.to("command", record.getCommand()))));
                        sender.sendMessage(I18nManager.INSTANCE.get("command.cbspy.query.loc.execution_count", MapsKt.mapOf(TuplesKt.to("executionCount", String.valueOf(record.getExecutionCount())))));
                        sender.sendMessage(I18nManager.INSTANCE.get("command.cbspy.query.loc.last_execution", MapsKt.mapOf(TuplesKt.to("lastExecution", record.getLastExecution()))));
                    } else {
                        String msg5 = I18nManager.get$default(I18nManager.INSTANCE, "command.cbspy.query.loc.not_found", null, 2, null);
                        sender.sendMessage(I18nManager.INSTANCE.get("prefix.cbspy.player", MapsKt.mapOf(TuplesKt.to("msg", msg5))));
                    }
                    return true;
                }
            }
            sender.sendMessage(I18nManager.get$default(I18nManager.INSTANCE, "command.cbspy.unknown", null, 2, null));
        }
        return true;
    }

    @Nullable
    public final Integer parseIntArg(@NotNull String arg, @NotNull String name, @NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(arg, "arg");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(sender, "sender");
        Integer n = StringsKt.toIntOrNull(arg);
        if (n == null) {
            MonitorCommand $this$parseIntArg_u24lambda_u240 = this;
            boolean bl = false;
            sender.sendMessage(I18nManager.INSTANCE.get("command.cbspy.query.loc.invalid_format", MapsKt.mapOf(TuplesKt.to("name", name))));
            n = null;
        }
        return n;
    }
}

