/*
 * Decompiled with CFR 0.152.
 */
package gold.eggs.commandblockspy;

import gold.eggs.commandblockspy.CommandBlockInfo;
import gold.eggs.commandblockspy.ConfigManager;
import gold.eggs.commandblockspy.DatabaseManager;
import gold.eggs.commandblockspy.MainPlugin;
import gold.eggs.commandblockspy.UtilsKt;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lgold/eggs/commandblockspy/CbSpyListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "commandBlockMonitor", "", "event", "Lorg/bukkit/event/server/ServerCommandEvent;", "commandBlockInterceptor", "onMinecartCreate", "Lorg/bukkit/event/vehicle/VehicleCreateEvent;", "command-block-spy"})
public final class CbSpyListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public final void commandBlockMonitor(@NotNull ServerCommandEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        CommandBlockInfo commandBlockInfo = UtilsKt.extractCommandBlockInfo(event);
        if (commandBlockInfo == null) {
            return;
        }
        CommandBlockInfo info = commandBlockInfo;
        if (!event.isCancelled() && ConfigManager.INSTANCE.getDatabaseLoggingEnabled()) {
            DatabaseManager.INSTANCE.recordCommandExecution(info.getCommand(), info.getLocation());
        }
        if (ConfigManager.INSTANCE.getBackendMonitorEnabled()) {
            MainPlugin.Companion.getInstance().getLogger().info("[\u6267\u884c] " + info.getType() + " | " + info.getWorldName() + "," + info.getX() + "," + info.getY() + "," + info.getZ() + " | " + info.getCommand());
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            if (!ConfigManager.INSTANCE.isPlayerMonitoring(uUID)) continue;
            player.sendMessage(((TextComponent)Component.text((String)("\u00a7e[CBSpy] \u00a76" + info.getType() + " \u00a7f| ")).append(((TextComponent)Component.text((String)("\u00a7a" + info.getWorldName() + "\u00a7f, \u00a7a" + info.getX() + "\u00a7f, \u00a7a" + info.getY() + "\u00a7f, \u00a7a" + info.getZ())).clickEvent(ClickEvent.runCommand((String)("/tp @s " + info.getX() + " " + info.getY() + " " + info.getZ())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((Component)Component.text((String)"\u70b9\u51fb\u4f20\u9001\u5230\u8be5\u547d\u4ee4\u65b9\u5757")))))).append((Component)Component.text((String)(" \u00a7f| \u00a77" + info.getCommand()))));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void commandBlockInterceptor(@NotNull ServerCommandEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ConfigManager.INSTANCE.getBanCommandMinecart() && event.getSender() instanceof CommandMinecart) {
            CommandSender commandSender = event.getSender();
            Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Entity");
            Entity sender = (Entity)commandSender;
            event.setCancelled(true);
            sender.remove();
            MainPlugin.Companion.getInstance().getLogger().info("[\u62e6\u622a] \u547d\u4ee4\u65b9\u5757\u77ff\u8f66 | " + sender.getLocation().getWorld() + "," + sender.getLocation().getBlockX() + "," + sender.getLocation().getBlockY() + "," + sender.getLocation().getBlockZ());
            return;
        }
        CommandBlockInfo commandBlockInfo = UtilsKt.extractCommandBlockInfo(event);
        if (commandBlockInfo == null) {
            return;
        }
        CommandBlockInfo info = commandBlockInfo;
        if (ConfigManager.INSTANCE.getInterceptRepeatingAuto() && Intrinsics.areEqual(info.getType(), "\u5faa\u73af") && Intrinsics.areEqual(UtilsKt.getAuto(info.getCommandBlock()), true)) {
            UtilsKt.setAuto(info.getCommandBlock(), false);
            event.setCancelled(true);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(Component.text((String)"\u00a7e[CBSpy] \u00a7c\u5df2\u62e6\u622a\u5faa\u73af\u4fdd\u6301\u5f00\u542f\u547d\u4ee4\u65b9\u5757 ").append(((TextComponent)Component.text((String)("\u00a7a" + info.getWorldName() + ", " + info.getX() + ", " + info.getY() + ", " + info.getZ())).clickEvent(ClickEvent.runCommand((String)("/tp @s " + info.getX() + " " + info.getY() + " " + info.getZ())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((Component)Component.text((String)"\u70b9\u51fb\u4f20\u9001\u5230\u8be5\u547d\u4ee4\u65b9\u5757"))))));
            }
            MainPlugin.Companion.getInstance().getLogger().info("[\u62e6\u622a] \u5faa\u73af\u547d\u4ee4\u65b9\u5757 | " + info.getWorldName() + "," + info.getX() + "," + info.getY() + "," + info.getZ() + " | " + info.getCommand());
            return;
        }
        if (ConfigManager.INSTANCE.getRegexInterceptEnabled()) {
            for (Map.Entry<Regex, String> entry : ConfigManager.INSTANCE.getRegexBlockList().entrySet()) {
                Regex regex = entry.getKey();
                String reason = entry.getValue();
                if (!regex.containsMatchIn(info.getCommand())) continue;
                event.setCancelled(true);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.sendMessage(Component.text((String)("\u00a7e[CBSpy] \u00a7c\u5df2\u62e6\u622a\u547d\u4ee4\u65b9\u5757: \u00a76" + reason + " ")).append(((TextComponent)Component.text((String)("\u00a7a" + info.getWorldName() + ", " + info.getX() + ", " + info.getY() + ", " + info.getZ())).clickEvent(ClickEvent.runCommand((String)("/tp @s " + info.getX() + " " + info.getY() + " " + info.getZ())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((Component)Component.text((String)"\u70b9\u51fb\u4f20\u9001\u5230\u8be5\u547d\u4ee4\u65b9\u5757"))))));
                }
                MainPlugin.Companion.getInstance().getLogger().info("[\u62e6\u622a] \u6b63\u5219\u8868\u8fbe\u5f0f | " + reason + " | " + info.getWorldName() + "," + info.getX() + "," + info.getY() + "," + info.getZ() + " | " + info.getCommand());
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onMinecartCreate(@NotNull VehicleCreateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!ConfigManager.INSTANCE.getBanCommandMinecart()) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        Intrinsics.checkNotNullExpressionValue(vehicle, "getVehicle(...)");
        Vehicle entity = vehicle;
        if (entity instanceof CommandMinecart) {
            event.setCancelled(true);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage((Component)Component.text((String)("\u00a7e[CBSpy] \u00a7c\u5df2\u62e6\u622a\u547d\u4ee4\u65b9\u5757\u77ff\u8f66: \u00a7a" + ((CommandMinecart)entity).getLocation().getWorld().getName() + ", " + ((CommandMinecart)entity).getLocation().getBlockX() + ", " + ((CommandMinecart)entity).getLocation().getBlockY() + ", " + ((CommandMinecart)entity).getLocation().getBlockZ())));
            }
            MainPlugin.Companion.getInstance().getLogger().info("[\u62e6\u622a] \u547d\u4ee4\u65b9\u5757\u77ff\u8f66 | " + ((CommandMinecart)entity).getLocation().getWorld() + "," + ((CommandMinecart)entity).getLocation().getBlockX() + "," + ((CommandMinecart)entity).getLocation().getBlockY() + "," + ((CommandMinecart)entity).getLocation().getBlockZ());
        }
    }
}

