/*
 * Decompiled with CFR 0.152.
 */
package net.jason.cool.network;

import java.util.HashMap;
import net.jason.cool.CoolMod;
import net.jason.cool.procedures.FireResistanceProcedure;
import net.jason.cool.procedures.HealProcedure;
import net.jason.cool.procedures.HealthlProcedure;
import net.jason.cool.procedures.HungerProcedure;
import net.jason.cool.procedures.InvisableProcedure;
import net.jason.cool.procedures.JumpProcedure;
import net.jason.cool.procedures.LuckProcedure;
import net.jason.cool.procedures.PoisonProcedure;
import net.jason.cool.procedures.SlownessProcedure;
import net.jason.cool.procedures.SpeedProcedure;
import net.jason.cool.procedures.StrengthProcedure;
import net.jason.cool.procedures.SuicideProcedure;
import net.jason.cool.procedures.WaterBreathingProcedure;
import net.jason.cool.procedures.WeaknessProcedure;
import net.jason.cool.world.inventory.CoolUiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CoolUiButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CoolUiButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cool", (String)"cool_ui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CoolUiButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new CoolUiButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<CoolUiButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CoolUiButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                CoolUiButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = CoolUiMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            HealthlProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            HungerProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            JumpProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SpeedProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            HealProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SuicideProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            InvisableProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            StrengthProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            FireResistanceProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            LuckProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            PoisonProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            WaterBreathingProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            SlownessProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            WeaknessProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CoolMod.addNetworkMessage(TYPE, STREAM_CODEC, CoolUiButtonMessage::handleData);
    }
}

