/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.slimeranchermod.entity;

import javax.annotation.Nullable;
import net.mcreator.slimeranchermod.entity.RoostroEntity;
import net.mcreator.slimeranchermod.init.SlimeRancherModModEntities;
import net.mcreator.slimeranchermod.procedures.ThundercluckPriNachalnomPrizyvieSushchnostiProcedure;
import net.mcreator.slimeranchermod.procedures.ThundercluckPriShchielchkiePKMPoSushchnostiProcedure;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class ThundercluckEntity
extends PathfinderMob {
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public ThundercluckEntity(EntityType<ThundercluckEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.chicken.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.chicken.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.chicken.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        ThundercluckPriNachalnomPrizyvieSushchnostiProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        ThundercluckEntity entity = this;
        Level world = this.level();
        if (!world.isClientSide && ThundercluckEntity.isSeeds(itemstack) && this.canBreedNow()) {
            if (!sourceentity.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.setInLove(600);
            this.spawnHearts((ServerLevel)world, 5);
            this.tryBreedWithNearbyPartner((ServerLevel)world);
        }
        ThundercluckPriShchielchkiePKMPoSushchnostiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    private static boolean isSeeds(ItemStack stack) {
        return stack.is(Items.WHEAT_SEEDS) || stack.is(Items.BEETROOT_SEEDS) || stack.is(Items.MELON_SEEDS) || stack.is(Items.PUMPKIN_SEEDS);
    }

    boolean canBreedNow() {
        long cooldownUntil;
        long gameTime = this.level().getGameTime();
        return gameTime >= (cooldownUntil = this.getPersistentData().getLong("sr_breed_cooldown_until").orElse(0L).longValue());
    }

    void setInLove(int durationTicks) {
        long until = this.level().getGameTime() + (long)durationTicks;
        this.getPersistentData().putLong("sr_love_until", until);
    }

    boolean isInLove() {
        return this.level().getGameTime() <= this.getPersistentData().getLong("sr_love_until").orElse(0L);
    }

    void clearLoveAndSetCooldown() {
        this.getPersistentData().putLong("sr_love_until", 0L);
        this.getPersistentData().putLong("sr_breed_cooldown_until", this.level().getGameTime() + 6000L);
    }

    void spawnHearts(ServerLevel server, int count) {
        for (int i = 0; i < count; ++i) {
            double ox = (server.random.nextDouble() - 0.5) * 0.6;
            double oy = server.random.nextDouble() * 0.5 + 0.3;
            double oz = (server.random.nextDouble() - 0.5) * 0.6;
            server.sendParticles((ParticleOptions)ParticleTypes.HEART, this.getX() + ox, this.getY() + oy, this.getZ() + oz, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void tryBreedWithNearbyPartner(ServerLevel server) {
        if (!this.isInLove()) {
            return;
        }
        AABB box = this.getBoundingBox().inflate(8.0);
        for (Entity e : server.getEntities((Entity)this, box, ent -> ent instanceof ThundercluckEntity)) {
            RoostroEntity partner = (RoostroEntity)e;
            if (!partner.isAlive() || !partner.isInLove() || !partner.canBreedNow()) continue;
            Entity baby = ((EntityType)SlimeRancherModModEntities.THUNDER_CHICKADO.get()).create((Level)server, EntitySpawnReason.SPAWN_ITEM_USE);
            if (baby != null) {
                baby.setPos(this.getX(), this.getY(), this.getZ());
                server.addFreshEntity(baby);
                this.spawnHearts(server, 7);
                partner.spawnHearts(server, 7);
            }
            this.clearLoveAndSetCooldown();
            partner.clearLoveAndSetCooldown();
            break;
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(true, this.tickCount);
            this.animationState2.animateWhen(true, this.tickCount);
            this.animationState3.animateWhen(true, this.tickCount);
        }
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 3.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.55);
        return builder;
    }
}

