/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.slimeranchermod.network;

import net.mcreator.slimeranchermod.SlimeRancherModMod;
import net.mcreator.slimeranchermod.procedures.PlayerClickButtonHarvesterProcedure;
import net.mcreator.slimeranchermod.procedures.PlayerClickButtonHeartProcedure;
import net.mcreator.slimeranchermod.procedures.PlayerClickButtonPowerProcedure;
import net.mcreator.slimeranchermod.procedures.UpdateHarvesterProcedure;
import net.mcreator.slimeranchermod.procedures.UpdateHeartProcedure;
import net.mcreator.slimeranchermod.procedures.UpdatePowerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record FabricatormenuButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FabricatormenuButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"slime_rancher_mod", (String)"fabricatormenu_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FabricatormenuButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new FabricatormenuButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<FabricatormenuButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(FabricatormenuButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> FabricatormenuButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            UpdateHeartProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            UpdateHarvesterProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            UpdatePowerProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            PlayerClickButtonHeartProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            PlayerClickButtonHarvesterProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            PlayerClickButtonPowerProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SlimeRancherModMod.addNetworkMessage(TYPE, STREAM_CODEC, FabricatormenuButtonMessage::handleData);
    }
}

