/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.slimeranchermod.procedures;

import java.util.Comparator;
import java.util.List;
import net.mcreator.slimeranchermod.init.SlimeRancherModModEntities;
import net.mcreator.slimeranchermod.init.SlimeRancherModModItems;
import net.mcreator.slimeranchermod.init.SlimeRancherModModParticleTypes;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VackpackKazhdyiTikVRukieProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        boolean holdingVacpack = livingEntity.getMainHandItem().is((Item)SlimeRancherModModItems.VACPACK_VACING.get()) || livingEntity.getOffhandItem().is((Item)SlimeRancherModModItems.VACPACK_VACING.get());
        CustomData customData = (CustomData)itemstack.get(DataComponents.CUSTOM_DATA);
        if (holdingVacpack && customData != null && customData.getUnsafe().getBoolean("vacpack use").orElse(false).booleanValue()) {
            Vec3 center = new Vec3(x, y, z);
            double radius = 7.0;
            double basePull = 0.06;
            double pullPerBlock = 0.012;
            double maxPull = 0.25;
            double fovAngle = 45.0;
            List<Entity> entitiesFound = world.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(radius), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList();
            Vec3 lookDirection = entity.getLookAngle();
            double shoulderY = y + (double)entity.getBbHeight() * 0.6;
            double suctionDistance = 0.6;
            Vec3 suctionPoint = new Vec3(x, shoulderY, z).add(lookDirection.scale(suctionDistance));
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                Vec3 origin = new Vec3(x, shoulderY, z);
                Vec3 up = new Vec3(0.0, 1.0, 0.0);
                Vec3 u = lookDirection.cross(up);
                if (u.lengthSqr() < 1.0E-6) {
                    u = lookDirection.cross(new Vec3(1.0, 0.0, 0.0));
                }
                u = u.normalize();
                Vec3 v = lookDirection.cross(u).normalize();
                double startDist = 0.6;
                double endDist = radius;
                int rings = 7;
                int minCount = 1;
                int maxCount = 5;
                double minRadius = 0.06;
                double maxRadius = 1.0;
                double baseAngle = (double)(entity.tickCount % 360) * 0.08;
                for (int r = 0; r < rings; ++r) {
                    double t = rings == 1 ? 1.0 : (double)r / (double)(rings - 1);
                    double dist = startDist + (endDist - startDist) * t;
                    double ringRadius = minRadius + (maxRadius - minRadius) * t;
                    int count = (int)Math.round((double)minCount + (double)(maxCount - minCount) * t);
                    for (int i = 0; i < count; ++i) {
                        double angle = baseAngle + Math.PI * 2 * (double)i / (double)Math.max(1, count) + t * (Math.PI * 2);
                        Vec3 offset = u.scale(Math.cos(angle) * ringRadius).add(v.scale(Math.sin(angle) * ringRadius));
                        Vec3 p = origin.add(lookDirection.scale(dist)).add(offset);
                        serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)SlimeRancherModModParticleTypes.VAC_PARTICLE.get()), p.x, p.y, p.z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            for (Entity entityIterator : entitiesFound) {
                EntityType entityType;
                double dist;
                Vec3 toPoint;
                Vec3 toEntityDirection;
                double angle;
                EntityType type;
                ResourceLocation entityId = EntityType.getKey((EntityType)entityIterator.getType());
                if (entityId == null || entityIterator instanceof LivingEntity && ((type = entityIterator.getType()) == EntityType.ENDER_DRAGON || type == EntityType.ELDER_GUARDIAN) || !((angle = Math.toDegrees(Math.acos(lookDirection.dot(toEntityDirection = entityIterator.position().subtract(center).normalize())))) <= fovAngle)) continue;
                if (entityIterator instanceof ItemEntity) {
                    toPoint = suctionPoint.subtract(entityIterator.position());
                    dist = Math.min(radius, toPoint.length());
                    double pull = Math.min(maxPull, basePull + pullPerBlock * (dist / radius));
                    Vec3 add = toPoint.normalize().scale(pull);
                    entityIterator.setDeltaMovement(entityIterator.getDeltaMovement().add(add));
                    continue;
                }
                if (!(entityIterator instanceof LivingEntity) || entityIterator == entity) continue;
                toPoint = suctionPoint.subtract(entityIterator.position());
                dist = Math.min(radius, toPoint.length());
                double pull = Math.min(maxPull, basePull + pullPerBlock * (dist / radius));
                Vec3 add = toPoint.normalize().scale(pull);
                entityIterator.setDeltaMovement(entityIterator.getDeltaMovement().add(add));
                if (dist < 0.75) {
                    entityIterator.setDeltaMovement(entityIterator.getDeltaMovement().scale(0.3));
                }
                double throatRadius = 0.35;
                if (toPoint.length() > throatRadius && entityIterator.getY() < shoulderY - 0.15) {
                    entityIterator.setDeltaMovement(entityIterator.getDeltaMovement().add(0.02, 0.03, 0.02));
                }
                if (!(dist < 0.8) || (entityType = entityIterator.getType()) != SlimeRancherModModEntities.HEN_HEN.get() || !(world instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)world;
                ItemStack drop = new ItemStack((ItemLike)SlimeRancherModModItems.HEN_HEN_SPAWN_EGG.get());
                ItemEntity eggEntity = new ItemEntity((Level)serverLevel, x, y, z, drop);
                serverLevel.addFreshEntity((Entity)eggEntity);
                entityIterator.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

