/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.slimeranchermod.procedures;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.mcreator.slimeranchermod.init.SlimeRancherModModBlocks;
import net.mcreator.slimeranchermod.init.SlimeRancherModModItems;
import net.mcreator.slimeranchermod.network.SlimeRancherModModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@EventBusSubscriber
public class WhenPlayerHaveVacPackProcedure {
    private static final Map<String, BlockGazeData> gazeTracking = new HashMap<String, BlockGazeData>();
    private static final int REQUIRED_GAZE_TIME = 60;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        WhenPlayerHaveVacPackProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), (Entity)event.getEntity());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        WhenPlayerHaveVacPackProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!WhenPlayerHaveVacPackProcedure.isVacPackActive(entity)) {
            WhenPlayerHaveVacPackProcedure.resetGazeTracking(entity);
            return;
        }
        if (!WhenPlayerHaveVacPackProcedure.canPlayerUseHarvester(entity)) {
            WhenPlayerHaveVacPackProcedure.resetGazeTracking(entity);
            return;
        }
        BlockPos targetBlockPos = WhenPlayerHaveVacPackProcedure.getTargetedBlockPos(entity, 5.0);
        if (targetBlockPos == null) {
            WhenPlayerHaveVacPackProcedure.resetGazeTracking(entity);
            return;
        }
        BlockState targetBlockState = world.getBlockState(targetBlockPos);
        if (!WhenPlayerHaveVacPackProcedure.isTargetBlock(targetBlockState)) {
            WhenPlayerHaveVacPackProcedure.resetGazeTracking(entity);
            return;
        }
        String playerKey = WhenPlayerHaveVacPackProcedure.getPlayerKey(entity);
        BlockGazeData gazeData = gazeTracking.getOrDefault(playerKey, new BlockGazeData());
        if (!gazeData.blockPos.equals((Object)targetBlockPos) || !gazeData.blockState.equals((Object)targetBlockState)) {
            gazeData.reset(targetBlockPos, targetBlockState);
        }
        ++gazeData.gazeTicks;
        WhenPlayerHaveVacPackProcedure.spawnParticles(world, targetBlockPos, gazeData.gazeTicks);
        if (gazeData.gazeTicks >= 60) {
            WhenPlayerHaveVacPackProcedure.activateBlockEffect(world, targetBlockPos, targetBlockState, entity);
            gazeData.reset(targetBlockPos, targetBlockState);
        }
        gazeTracking.put(playerKey, gazeData);
    }

    private static boolean isVacPackActive(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainHand = player.getMainHandItem();
            ItemStack offHand = player.getOffhandItem();
            boolean hasActiveVacPack = WhenPlayerHaveVacPackProcedure.isVacPackItem(mainHand) && WhenPlayerHaveVacPackProcedure.isVacPackActive(mainHand) || WhenPlayerHaveVacPackProcedure.isVacPackItem(offHand) && WhenPlayerHaveVacPackProcedure.isVacPackActive(offHand);
            return hasActiveVacPack;
        }
        return false;
    }

    private static boolean canPlayerUseHarvester(Entity entity) {
        return ((SlimeRancherModModVariables.PlayerVariables)entity.getData(SlimeRancherModModVariables.PLAYER_VARIABLES)).Player_Can_Use_Harvester;
    }

    private static boolean isVacPackItem(ItemStack itemStack) {
        return itemStack.getItem() == SlimeRancherModModItems.VACPACK_VACING.get();
    }

    private static boolean isVacPackActive(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        if (customData != null) {
            CompoundTag tag = customData.copyTag();
            return tag.getBooleanOr("vacpack use", false);
        }
        return false;
    }

    private static BlockPos getTargetedBlockPos(Entity entity, double maxDistance) {
        Player player;
        HitResult hitResult;
        if (entity instanceof Player && (hitResult = (player = (Player)entity).pick(maxDistance, 1.0f, false)).getType() == HitResult.Type.BLOCK) {
            return ((BlockHitResult)hitResult).getBlockPos();
        }
        return null;
    }

    private static boolean isTargetBlock(BlockState blockState) {
        return blockState.getBlock() == SlimeRancherModModBlocks.LAVA_DUST_SPRING_FLOW.get() || blockState.getBlock() == SlimeRancherModModBlocks.PRIMORDY_OIL_SPRING_FLOW.get() || blockState.getBlock() == SlimeRancherModModBlocks.SILKY_SAND_SPRING_FLOW.get() || blockState.getBlock() == SlimeRancherModModBlocks.AQUA_GLASS_SPRING_FLOW.get() || blockState.getBlock() == SlimeRancherModModBlocks.SPIRAL_STEAM_SPRING_FLOW.get() || blockState.getBlock() == SlimeRancherModModBlocks.SUN_SAP_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.INDIGONIUM_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.BLACK_INDIGONIUM_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.TIN_PETAL_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.JELLYSTONE_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.RADIANT_ORE_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.WILD_HONEY_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.ROYAL_JELLY_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.PAPPER_JAM_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.MAGMA_COMB_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.HEXACOMB_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.BUZZ_WAX_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.DEEP_BRINE_SPRING_FLOW.get() || blockState.getBlock() == SlimeRancherModModBlocks.SLIME_FOSSIL_FULL.get() || blockState.getBlock() == SlimeRancherModModBlocks.STRANGE_DIAMOND_FULL.get();
    }

    private static void spawnParticles(LevelAccessor world, BlockPos pos, int gazeTicks) {
        if (world.isClientSide()) {
            double progress = (double)gazeTicks / 60.0;
            int particleCount = (int)(progress * 10.0) + 1;
            for (int i = 0; i < particleCount; ++i) {
                double px = (double)pos.getX() + 0.5 + (world.getRandom().nextDouble() - 0.5);
                double py = (double)pos.getY() + 0.5 + (world.getRandom().nextDouble() - 0.5);
                double pz = (double)pos.getZ() + 0.5 + (world.getRandom().nextDouble() - 0.5);
                world.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, px, py, pz, (world.getRandom().nextDouble() - 0.5) * 0.1, (world.getRandom().nextDouble() - 0.5) * 0.1, (world.getRandom().nextDouble() - 0.5) * 0.1);
            }
        }
    }

    private static void activateBlockEffect(LevelAccessor world, BlockPos pos, BlockState oldState, Entity entity) {
        BlockState newState = null;
        ItemStack baseItem = null;
        if (oldState.getBlock() == SlimeRancherModModBlocks.LAVA_DUST_SPRING_FLOW.get()) {
            newState = ((Block)SlimeRancherModModBlocks.LAVA_DUST_SPRING_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.LAVA_DUST.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.PRIMORDY_OIL_SPRING_FLOW.get()) {
            newState = ((Block)SlimeRancherModModBlocks.PRIMORDY_OIL_SPRING_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.PRIMORDY_OIL.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.SILKY_SAND_SPRING_FLOW.get()) {
            newState = ((Block)SlimeRancherModModBlocks.SILKY_SAND_SPRING_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.SILKY_SAND.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.AQUA_GLASS_SPRING_FLOW.get()) {
            newState = ((Block)SlimeRancherModModBlocks.AQUA_GLASS_SPRING_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.AQUA_GLASS.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.SPIRAL_STEAM_SPRING_FLOW.get()) {
            newState = ((Block)SlimeRancherModModBlocks.SPIRAL_STEAM_SPRING_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.SPIRAL_STEAM.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.SUN_SAP_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.SUN_SAP_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.SUN_SAP.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.INDIGONIUM_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.INDIGONIUM_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.INDIGONIUM.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.BLACK_INDIGONIUM_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.BLACK_INDIGONIUM_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.BLACK_INDIGONIUM.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.TIN_PETAL_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.TIN_PETAL_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.TIN_PETAL.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.JELLYSTONE_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.JELLYSTONE_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.JELLYSTONE.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.RADIANT_ORE_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.RADIANT_ORE_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.RADIANT_ORE.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.WILD_HONEY_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.WILD_HONEY_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.WILD_HONEY.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.ROYAL_JELLY_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.ROYAL_JELLY_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.ROYAL_JELLY.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.PAPPER_JAM_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.PAPPER_JAM_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.PEPPER_JAM.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.MAGMA_COMB_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.MAGMA_COMB_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.MAGMA_COMB.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.HEXACOMB_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.HEXACOMB_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.HEXACOMB.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.BUZZ_WAX_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.BUZZ_WAX_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.BUZZ_WAX.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.DEEP_BRINE_SPRING_FLOW.get()) {
            newState = ((Block)SlimeRancherModModBlocks.DEEP_BRINE_SPRING_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.DEEP_BRINE.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.SLIME_FOSSIL_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.SLIME_FOSSIL_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.SLIME_FOSSIL.get());
        } else if (oldState.getBlock() == SlimeRancherModModBlocks.STRANGE_DIAMOND_FULL.get()) {
            newState = ((Block)SlimeRancherModModBlocks.STRANGE_DIAMOND_EMPTY.get()).defaultBlockState();
            baseItem = new ItemStack((ItemLike)SlimeRancherModModItems.STRANGE_DIAMOND.get());
        }
        if (newState != null && baseItem != null) {
            BlockState finalState = newState;
            BlockState currentState = world.getBlockState(pos);
            for (Property propertyOld : currentState.getProperties()) {
                Property propertyNew = finalState.getBlock().getStateDefinition().getProperty(propertyOld.getName());
                if (propertyNew == null || finalState.getValue(propertyNew) == null) continue;
                try {
                    finalState = (BlockState)finalState.setValue(propertyNew, currentState.getValue(propertyOld));
                }
                catch (Exception exception) {}
            }
            world.setBlock(pos, finalState, 3);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                RandomSource random = world.getRandom();
                int itemCount = random.nextInt(3) + 1;
                ItemStack itemToGive = baseItem.copy();
                itemToGive.setCount(itemCount);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)itemToGive);
            }
        }
    }

    private static void resetGazeTracking(Entity entity) {
        gazeTracking.remove(WhenPlayerHaveVacPackProcedure.getPlayerKey(entity));
    }

    private static String getPlayerKey(Entity entity) {
        return entity.getStringUUID();
    }

    private static class BlockGazeData {
        public BlockPos blockPos = BlockPos.ZERO;
        public BlockState blockState;
        public int gazeTicks = 0;

        private BlockGazeData() {
        }

        public void reset(BlockPos newPos, BlockState newState) {
            this.blockPos = newPos;
            this.blockState = newState;
            this.gazeTicks = 0;
        }
    }
}

