/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.slimeranchermod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JellystoneFullBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public JellystoneFullBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.BASALT).strength(-1.0f, 3600000.0f).noOcclusion().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)JellystoneFullBlock.box((double)6.0, (double)-2.0, (double)-2.0, (double)16.0, (double)9.0, (double)12.0), (VoxelShape[])new VoxelShape[]{JellystoneFullBlock.box((double)8.0, (double)1.0, (double)-1.0, (double)18.0, (double)8.0, (double)14.0), JellystoneFullBlock.box((double)5.0, (double)-1.0, (double)-3.0, (double)17.0, (double)5.0, (double)15.0), JellystoneFullBlock.box((double)7.5, (double)7.61986, (double)1.95831, (double)12.0, (double)12.11986, (double)6.45831), JellystoneFullBlock.box((double)15.25, (double)8.36986, (double)1.45831, (double)16.25, (double)9.36986, (double)2.45831), JellystoneFullBlock.box((double)9.0, (double)8.36986, (double)-5.04169, (double)11.0, (double)10.36986, (double)-3.04169), JellystoneFullBlock.box((double)12.5, (double)7.11986, (double)7.45831, (double)15.5, (double)10.11986, (double)10.45831), JellystoneFullBlock.box((double)7.5, (double)3.61986, (double)11.20831, (double)10.5, (double)6.61986, (double)14.20831), JellystoneFullBlock.box((double)4.0, (double)3.86986, (double)-0.04169, (double)6.0, (double)5.86986, (double)1.95831), JellystoneFullBlock.box((double)0.25, (double)4.5, (double)3.5, (double)8.75, (double)13.0, (double)12.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)JellystoneFullBlock.box((double)0.0, (double)-2.0, (double)4.0, (double)10.0, (double)9.0, (double)18.0), (VoxelShape[])new VoxelShape[]{JellystoneFullBlock.box((double)-2.0, (double)1.0, (double)2.0, (double)8.0, (double)8.0, (double)17.0), JellystoneFullBlock.box((double)-1.0, (double)-1.0, (double)1.0, (double)11.0, (double)5.0, (double)19.0), JellystoneFullBlock.box((double)4.0, (double)7.61986, (double)9.54169, (double)8.5, (double)12.11986, (double)14.04169), JellystoneFullBlock.box((double)-0.25, (double)8.36986, (double)13.54169, (double)0.75, (double)9.36986, (double)14.54169), JellystoneFullBlock.box((double)5.0, (double)8.36986, (double)19.04169, (double)7.0, (double)10.36986, (double)21.04169), JellystoneFullBlock.box((double)0.5, (double)7.11986, (double)5.54169, (double)3.5, (double)10.11986, (double)8.54169), JellystoneFullBlock.box((double)5.5, (double)3.61986, (double)1.79169, (double)8.5, (double)6.61986, (double)4.79169), JellystoneFullBlock.box((double)10.0, (double)3.86986, (double)14.04169, (double)12.0, (double)5.86986, (double)16.04169), JellystoneFullBlock.box((double)7.25, (double)4.5, (double)4.0, (double)15.75, (double)13.0, (double)12.5)});
            case Direction.EAST -> Shapes.or((VoxelShape)JellystoneFullBlock.box((double)-2.0, (double)-2.0, (double)0.0, (double)12.0, (double)9.0, (double)10.0), (VoxelShape[])new VoxelShape[]{JellystoneFullBlock.box((double)-1.0, (double)1.0, (double)-2.0, (double)14.0, (double)8.0, (double)8.0), JellystoneFullBlock.box((double)-3.0, (double)-1.0, (double)-1.0, (double)15.0, (double)5.0, (double)11.0), JellystoneFullBlock.box((double)1.95831, (double)7.61986, (double)4.0, (double)6.45831, (double)12.11986, (double)8.5), JellystoneFullBlock.box((double)1.45831, (double)8.36986, (double)-0.25, (double)2.45831, (double)9.36986, (double)0.75), JellystoneFullBlock.box((double)-5.04169, (double)8.36986, (double)5.0, (double)-3.04169, (double)10.36986, (double)7.0), JellystoneFullBlock.box((double)7.45831, (double)7.11986, (double)0.5, (double)10.45831, (double)10.11986, (double)3.5), JellystoneFullBlock.box((double)11.20831, (double)3.61986, (double)5.5, (double)14.20831, (double)6.61986, (double)8.5), JellystoneFullBlock.box((double)-0.04169, (double)3.86986, (double)10.0, (double)1.95831, (double)5.86986, (double)12.0), JellystoneFullBlock.box((double)3.5, (double)4.5, (double)7.25, (double)12.0, (double)13.0, (double)15.75)});
            case Direction.WEST -> Shapes.or((VoxelShape)JellystoneFullBlock.box((double)4.0, (double)-2.0, (double)6.0, (double)18.0, (double)9.0, (double)16.0), (VoxelShape[])new VoxelShape[]{JellystoneFullBlock.box((double)2.0, (double)1.0, (double)8.0, (double)17.0, (double)8.0, (double)18.0), JellystoneFullBlock.box((double)1.0, (double)-1.0, (double)5.0, (double)19.0, (double)5.0, (double)17.0), JellystoneFullBlock.box((double)9.54169, (double)7.61986, (double)7.5, (double)14.04169, (double)12.11986, (double)12.0), JellystoneFullBlock.box((double)13.54169, (double)8.36986, (double)15.25, (double)14.54169, (double)9.36986, (double)16.25), JellystoneFullBlock.box((double)19.04169, (double)8.36986, (double)9.0, (double)21.04169, (double)10.36986, (double)11.0), JellystoneFullBlock.box((double)5.54169, (double)7.11986, (double)12.5, (double)8.54169, (double)10.11986, (double)15.5), JellystoneFullBlock.box((double)1.79169, (double)3.61986, (double)7.5, (double)4.79169, (double)6.61986, (double)10.5), JellystoneFullBlock.box((double)14.04169, (double)3.86986, (double)4.0, (double)16.04169, (double)5.86986, (double)6.0), JellystoneFullBlock.box((double)4.0, (double)4.5, (double)0.25, (double)12.5, (double)13.0, (double)8.75)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }
}

