/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.slimeranchermod.block;

import net.mcreator.slimeranchermod.init.SlimeRancherModModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NestPaintedBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public NestPaintedBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.HARD_CROP).strength(1.0f).noCollission().noOcclusion().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        if (!world.isClientSide) {
            world.scheduleTick(pos, (Block)this, 24000);
        }
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)NestPaintedBlock.box((double)3.0, (double)0.0, (double)11.0, (double)13.0, (double)2.0, (double)15.0), (VoxelShape[])new VoxelShape[]{NestPaintedBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)2.0, (double)5.0), NestPaintedBlock.box((double)11.0, (double)0.0, (double)3.0, (double)15.0, (double)2.0, (double)13.0), NestPaintedBlock.box((double)1.0, (double)0.0, (double)3.0, (double)5.0, (double)2.0, (double)13.0), NestPaintedBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)0.5, (double)11.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)NestPaintedBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)2.0, (double)5.0), (VoxelShape[])new VoxelShape[]{NestPaintedBlock.box((double)3.0, (double)0.0, (double)11.0, (double)13.0, (double)2.0, (double)15.0), NestPaintedBlock.box((double)1.0, (double)0.0, (double)3.0, (double)5.0, (double)2.0, (double)13.0), NestPaintedBlock.box((double)11.0, (double)0.0, (double)3.0, (double)15.0, (double)2.0, (double)13.0), NestPaintedBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)0.5, (double)11.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)NestPaintedBlock.box((double)11.0, (double)0.0, (double)3.0, (double)15.0, (double)2.0, (double)13.0), (VoxelShape[])new VoxelShape[]{NestPaintedBlock.box((double)1.0, (double)0.0, (double)3.0, (double)5.0, (double)2.0, (double)13.0), NestPaintedBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)2.0, (double)5.0), NestPaintedBlock.box((double)3.0, (double)0.0, (double)11.0, (double)13.0, (double)2.0, (double)15.0), NestPaintedBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)0.5, (double)11.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)NestPaintedBlock.box((double)1.0, (double)0.0, (double)3.0, (double)5.0, (double)2.0, (double)13.0), (VoxelShape[])new VoxelShape[]{NestPaintedBlock.box((double)11.0, (double)0.0, (double)3.0, (double)15.0, (double)2.0, (double)13.0), NestPaintedBlock.box((double)3.0, (double)0.0, (double)11.0, (double)13.0, (double)2.0, (double)15.0), NestPaintedBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)2.0, (double)5.0), NestPaintedBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)0.5, (double)11.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        double spawnX = (double)pos.getX() + 0.5;
        double spawnY = (double)pos.getY() + 0.6;
        double spawnZ = (double)pos.getZ() + 0.5;
        this.spawnEntityIfPossible(world, spawnX, spawnY, spawnZ, (EntityType)SlimeRancherModModEntities.PAINTED_HEN.get());
        if (random.nextFloat() < 0.2f) {
            this.spawnEntityIfPossible(world, spawnX, spawnY, spawnZ, (EntityType)SlimeRancherModModEntities.ROOSTRO.get());
        }
        if (random.nextFloat() < 0.05f) {
            this.spawnEntityIfPossible(world, spawnX, spawnY, spawnZ, (EntityType)SlimeRancherModModEntities.PAINTED_CHICKADO.get());
        }
        world.scheduleTick(pos, (Block)this, 24000);
    }

    private void spawnEntityIfPossible(ServerLevel world, double x, double y, double z, EntityType<?> entityType) {
        Entity entity = entityType.create((Level)world, EntitySpawnReason.SPAWN_ITEM_USE);
        if (entity != null) {
            entity.setPos(x, y, z);
            world.addFreshEntity(entity);
        }
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }
}

