/*
 * Decompiled with CFR 0.152.
 */
package DA.dARebootAuto;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class DARebootAuto
extends JavaPlugin {
    private List<String> rebootTimes;
    private int delayBeforeReboot;
    private String rebootMessage;
    private List<Integer> countdownWarnings;
    private boolean rebooting = false;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadValues();
        new BukkitRunnable(){

            public void run() {
                DARebootAuto.this.checkRebootTimes();
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
        this.getLogger().info("DARebootAuto enabled.");
    }

    public void onDisable() {
        this.getLogger().info("DARebootAuto disabled.");
    }

    private void reloadValues() {
        this.reloadConfig();
        this.rebootTimes = this.getConfig().getStringList("reboot-times");
        this.delayBeforeReboot = this.getConfig().getInt("delay-before-reboot", 15);
        this.rebootMessage = this.getConfig().getString("reboot-message", "&c[DARebootAuto] The server will restart in {delay} seconds!");
        this.countdownWarnings = this.getConfig().getIntegerList("countdown-warnings");
    }

    private void checkRebootTimes() {
        if (this.rebooting) {
            return;
        }
        String now = LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm"));
        if (this.rebootTimes.contains(now)) {
            this.getLogger().info("Reboot scheduled for " + now);
            this.rebootServer();
        }
    }

    private void rebootServer() {
        if (this.rebooting) {
            return;
        }
        this.rebooting = true;
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"save-all");
        new BukkitRunnable(){
            int remaining;
            {
                this.remaining = DARebootAuto.this.delayBeforeReboot;
            }

            public void run() {
                if (DARebootAuto.this.countdownWarnings.contains(this.remaining) || this.remaining == DARebootAuto.this.delayBeforeReboot) {
                    String msg = DARebootAuto.this.rebootMessage.replace("{delay}", String.valueOf(this.remaining));
                    Bukkit.broadcastMessage((String)DARebootAuto.this.colorize(msg));
                }
                if (this.remaining <= 1) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"restart");
                    this.cancel();
                }
                --this.remaining;
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("dareboot.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7eUsage: /dareboot <reload|now>");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.reloadValues();
                sender.sendMessage("\u00a7aDARebootAuto config reloaded.");
                break;
            }
            case "now": {
                sender.sendMessage("\u00a7cForcing immediate reboot...");
                this.rebootServer();
                break;
            }
            default: {
                sender.sendMessage("\u00a7eUsage: /dareboot <reload|now>");
            }
        }
        return true;
    }

    private String colorize(String text) {
        return text.replace("&", "\u00a7");
    }
}

