/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import java.util.Map;
import me.flashyreese.mods.nuit.util.CodecUtils;

public record Fade(long duration, Map<Long, Float> keyFrames) {
    public static final Codec<Fade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.getClampedLong(1L, Long.MAX_VALUE).optionalFieldOf("duration", (Object)24000L).forGetter(Fade::duration), (App)CodecUtils.unboundedMapFixed(Long.class, CodecUtils.getClampedFloat(0.0f, 1.0f), Long2FloatOpenHashMap::new).optionalFieldOf("keyFrames", CodecUtils.fastUtilLong2FloatOpenHashMap()).forGetter(Fade::keyFrames)).apply((Applicative)instance, Fade::new));

    public Fade(long duration, Map<Long, Float> keyFrames) {
        this.duration = duration;
        this.keyFrames = keyFrames;
        this.validateKeyFrames();
    }

    public static Fade of() {
        return new Fade(24000L, CodecUtils.fastUtilLong2FloatOpenHashMap());
    }

    private void validateKeyFrames() {
        for (Long keyFrame : this.keyFrames.keySet()) {
            try {
                if (keyFrame >= 0L && keyFrame < this.duration) continue;
                throw new IllegalArgumentException("Keyframes must be between 0 and duration");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Keyframes must be numeric", e);
            }
        }
    }
}

