/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.flashyreese.mods.nuit.util.CodecUtils;

public class RGB {
    public static final Codec<RGB> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.getClampedFloat(0.0f, 1.0f).fieldOf("red").forGetter(RGB::getRed), (App)CodecUtils.getClampedFloat(0.0f, 1.0f).fieldOf("green").forGetter(RGB::getGreen), (App)CodecUtils.getClampedFloat(0.0f, 1.0f).fieldOf("blue").forGetter(RGB::getBlue)).apply((Applicative)instance, RGB::new));
    private final float red;
    private final float green;
    private final float blue;

    public RGB(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public float getRed() {
        return this.red;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getGreen() {
        return this.green;
    }

    public RGB blend(RGB other, float alpha) {
        float invAlpha = 1.0f - alpha;
        return new RGB(this.getRed() * alpha + other.getRed() * invAlpha, this.getGreen() * alpha + other.getGreen() * invAlpha, this.getBlue() * alpha + other.getBlue() * invAlpha);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RGB) {
            RGB rgb = (RGB)obj;
            return this.red == rgb.red && this.green == rgb.green && this.blue == rgb.blue;
        }
        return super.equals(obj);
    }
}

