/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import me.flashyreese.mods.nuit.util.CodecUtils;
import me.flashyreese.mods.nuit.util.Utils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Tuple;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public record Rotation(boolean skyboxRotation, Map<Long, Quaternionf> mapping, Map<Long, Quaternionf> axis, long duration, float speed) {
    private static final Codec<Quaternionf> QUATERNIONF_FROM_VEC_3_F = Codec.FLOAT.listOf().comapFlatMap(list -> {
        if (list.size() != 3) {
            return DataResult.error(() -> "Invalid number of elements in vector");
        }
        return DataResult.success((Object)new Quaternionf().rotateLocalX((float)Math.toRadians(((Float)list.get(0)).floatValue())).rotateLocalY((float)Math.toRadians(((Float)list.get(1)).floatValue())).rotateLocalZ((float)Math.toRadians(((Float)list.get(2)).floatValue())));
    }, vec -> ImmutableList.of((Object)Float.valueOf(vec.x()), (Object)Float.valueOf(vec.y()), (Object)Float.valueOf(vec.z())));
    public static final Codec<Rotation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("skyboxRotation", (Object)true).forGetter(Rotation::skyboxRotation), (App)CodecUtils.unboundedMapFixed(Long.class, QUATERNIONF_FROM_VEC_3_F, Long2ObjectOpenHashMap::new).optionalFieldOf("mapping", CodecUtils.fastUtilLong2ObjectOpenHashMap()).forGetter(Rotation::mapping), (App)CodecUtils.unboundedMapFixed(Long.class, QUATERNIONF_FROM_VEC_3_F, Long2ObjectOpenHashMap::new).optionalFieldOf("axis", CodecUtils.fastUtilLong2ObjectOpenHashMap()).forGetter(Rotation::axis), (App)Codec.LONG.optionalFieldOf("duration", (Object)24000L).forGetter(Rotation::duration), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(1.0f)).forGetter(Rotation::speed)).apply((Applicative)instance, Rotation::new));

    public Matrix4f apply(Matrix4f matrix4f, ClientLevel level) {
        long currentTime = level.getDayTime() % this.duration;
        Quaternionf resultRot = new Quaternionf();
        Optional<Tuple<Long, Long>> possibleMappingKeyframes = Utils.findClosestKeyframes(this.mapping, currentTime);
        Quaternionf mappingRot = new Quaternionf();
        Optional<Tuple<Long, Long>> possibleAxisKeyframes = Utils.findClosestKeyframes(this.axis, currentTime);
        Quaternionf axisRot = new Quaternionf();
        possibleAxisKeyframes.ifPresent(axisKeyframe -> {
            mappingRot.mul((Quaternionfc)Utils.interpolateQuatKeyframes(this.axis, (Tuple<Long, Long>)axisKeyframe, currentTime, this.duration), axisRot);
            resultRot.mul((Quaternionfc)axisRot);
            double timeRotation = Utils.calculateRotation(this.speed, this.skyboxRotation, level);
            resultRot.mul((Quaternionfc)Axis.YP.rotationDegrees((float)timeRotation).mul((Quaternionfc)mappingRot));
            resultRot.mul((Quaternionfc)axisRot.conjugate());
        });
        possibleMappingKeyframes.ifPresent(mappingKeyframe -> {
            mappingRot.set((Quaternionfc)Utils.interpolateQuatKeyframes(this.mapping, (Tuple<Long, Long>)mappingKeyframe, currentTime, this.duration));
            resultRot.mul((Quaternionfc)mappingRot);
        });
        return matrix4f.rotate((Quaternionfc)resultRot);
    }

    public void apply(PoseStack poseStack, ClientLevel level) {
        poseStack.mulPose((Matrix4fc)this.apply(new Matrix4f(), level));
    }

    public static Rotation of() {
        return new Rotation(true, Map.of(), Map.of(), 24000L, 1.0f);
    }

    public static Rotation decorations() {
        return new Rotation(false, Map.of(), Map.of(), 24000L, 1.0f);
    }
}

