/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.Strictness;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.flashyreese.mods.nuit.NuitClient;
import me.flashyreese.mods.nuit.api.NuitApi;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class SkyboxResourceListener
implements PreparableReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().setStrictness(Strictness.LENIENT).create();

    public void readFiles(ResourceManager resourceManager) {
        NuitApi skyboxManager = NuitApi.getInstance();
        skyboxManager.clearSkyboxes();
        Map resources = resourceManager.listResources("sky", resourceLocation -> resourceLocation.getNamespace().startsWith("nuit") && resourceLocation.getPath().endsWith(".json"));
        resources.forEach((resourceLocation, resource) -> {
            try {
                JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(resource.open()), JsonObject.class);
                skyboxManager.addSkybox((ResourceLocation)resourceLocation, json);
            }
            catch (Exception e) {
                NuitClient.getLogger().error("Error reading skybox {}", (Object)resourceLocation.toString(), (Object)e);
            }
        });
    }

    @NotNull
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, Executor executor, Executor executor2) {
        return CompletableFuture.runAsync(() -> this.readFiles(resourceManager), executor2).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0));
    }
}

