/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import java.util.Map;
import java.util.Objects;
import me.flashyreese.mods.nuit.NuitClient;
import me.flashyreese.mods.nuit.api.skyboxes.NuitSkybox;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.components.Weather;
import me.flashyreese.mods.nuit.skybox.DefaultHandler;
import me.flashyreese.mods.nuit.util.Utils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;

public abstract class AbstractSkybox
implements NuitSkybox {
    private final Map<Long, Float> cachedKeyFrames = new Long2FloatOpenHashMap();
    public transient float alpha;
    protected Properties properties = Properties.of();
    protected Conditions conditions = Conditions.of();
    protected boolean unexpectedConditionTransition = false;
    protected long lastTime = -2L;
    protected float conditionAlpha = 0.0f;

    protected AbstractSkybox() {
    }

    protected AbstractSkybox(Properties properties, Conditions conditions) {
        this.properties = properties;
        this.conditions = conditions;
    }

    @Override
    public void tick(ClientLevel level) {
        this.updateAlpha(level);
    }

    @Override
    public void updateAlpha(ClientLevel level) {
        long currentTime = level.getDayTime() % this.properties.fade().duration();
        boolean condition = this.checkConditions();
        float fadeAlpha = 1.0f;
        if (this.properties.fade().keyFrames().isEmpty()) {
            this.conditionAlpha = Utils.calculateConditionAlphaValue(1.0f, 0.0f, this.conditionAlpha, condition ? this.properties.transitionInDuration() : this.properties.transitionOutDuration(), condition);
        } else {
            if (this.properties.fade().duration() <= NuitClient.config().generalSettings.fadeCacheDuration) {
                fadeAlpha = this.cachedKeyFrames.computeIfAbsent(currentTime, time -> {
                    Tuple<Long, Long> keyFrames = Utils.findClosestKeyframes(this.properties.fade().keyFrames(), time).orElseThrow();
                    return Float.valueOf(Utils.calculateInterpolatedAlpha(time, this.properties.fade().duration(), (Long)keyFrames.getA(), (Long)keyFrames.getB(), this.properties.fade().keyFrames().get(keyFrames.getA()).floatValue(), this.properties.fade().keyFrames().get(keyFrames.getB()).floatValue()));
                }).floatValue();
            } else {
                Tuple<Long, Long> keyFrames = Utils.findClosestKeyframes(this.properties.fade().keyFrames(), currentTime).orElseThrow();
                fadeAlpha = Utils.calculateInterpolatedAlpha(currentTime, this.properties.fade().duration(), (Long)keyFrames.getA(), (Long)keyFrames.getB(), this.properties.fade().keyFrames().get(keyFrames.getA()).floatValue(), this.properties.fade().keyFrames().get(keyFrames.getB()).floatValue());
            }
            if (!(this.lastTime != currentTime - 1L && this.lastTime != currentTime || this.unexpectedConditionTransition)) {
                this.conditionAlpha = Utils.calculateConditionAlphaValue(1.0f, 0.0f, this.conditionAlpha, condition ? this.properties.transitionInDuration() : this.properties.transitionOutDuration(), condition);
            } else {
                this.unexpectedConditionTransition = true;
                this.conditionAlpha = Utils.calculateConditionAlphaValue(1.0f, 0.0f, this.conditionAlpha, NuitClient.config().generalSettings.unexpectedTransitionDuration, condition);
                if (this.unexpectedConditionTransition && (this.conditionAlpha == 0.0f || this.conditionAlpha == 1.0f)) {
                    this.unexpectedConditionTransition = false;
                }
            }
        }
        this.alpha = fadeAlpha * this.conditionAlpha;
        this.lastTime = currentTime;
    }

    protected boolean checkConditions() {
        return this.checkDimensions() && this.checkWorlds() && this.checkBiomes() && this.checkXRanges() && this.checkYRanges() && this.checkZRanges() && this.checkWeather() && this.checkEffects() && this.checkProperties();
    }

    protected boolean checkBiomes() {
        Minecraft client = Minecraft.getInstance();
        Objects.requireNonNull(client.level);
        Objects.requireNonNull(client.player);
        return this.conditions.getBiomes().entries().isEmpty() || this.conditions.getBiomes().excludes() ^ (this.conditions.getBiomes().entries().contains(((ResourceKey)client.level.getBiome(client.player.blockPosition()).unwrapKey().orElseThrow()).location()) || this.conditions.getBiomes().entries().contains(DefaultHandler.DEFAULT) && DefaultHandler.checkFallbackBiomes());
    }

    protected boolean checkDimensions() {
        Minecraft client = Minecraft.getInstance();
        Objects.requireNonNull(client.level);
        return this.conditions.getDimensions().entries().isEmpty() || this.conditions.getDimensions().excludes() ^ (this.conditions.getDimensions().entries().contains(client.level.dimension().location()) || this.conditions.getDimensions().entries().contains(DefaultHandler.DEFAULT) && DefaultHandler.checkFallbackDimensions());
    }

    protected boolean checkWorlds() {
        Minecraft client = Minecraft.getInstance();
        Objects.requireNonNull(client.level);
        return this.conditions.getWorlds().entries().isEmpty() || this.conditions.getWorlds().excludes() ^ (this.conditions.getWorlds().entries().contains(client.level.dimensionType().effectsLocation()) || this.conditions.getWorlds().entries().contains(DefaultHandler.DEFAULT) && DefaultHandler.checkFallbackWorlds());
    }

    protected boolean checkEffects() {
        Minecraft client = Minecraft.getInstance();
        Objects.requireNonNull(client.level);
        Camera camera = client.gameRenderer.getMainCamera();
        if (this.conditions.getEffects().entries().isEmpty()) {
            LivingEntity livingEntity;
            Entity entity = camera.getEntity();
            return !(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).hasEffect(MobEffects.BLINDNESS) && !livingEntity.hasEffect(MobEffects.DARKNESS);
        }
        Entity entity = camera.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return this.conditions.getEffects().excludes() ^ this.conditions.getEffects().entries().stream().noneMatch(resourceLocation -> client.level.registryAccess().lookupOrThrow(Registries.MOB_EFFECT).get(resourceLocation).isPresent() && livingEntity.hasEffect(client.level.registryAccess().lookupOrThrow(Registries.MOB_EFFECT).wrapAsHolder((Object)((MobEffect)((Holder.Reference)client.level.registryAccess().lookupOrThrow(Registries.MOB_EFFECT).get(resourceLocation).get()).value()))));
        }
        return true;
    }

    protected boolean checkProperties() {
        Minecraft client = Minecraft.getInstance();
        Objects.requireNonNull(client.level);
        Camera camera = client.gameRenderer.getMainCamera();
        FogType cameraSubmersionType = camera.getFluidInCamera();
        boolean visibleUnderwater = this.properties.visibleUnderwater() || cameraSubmersionType != FogType.WATER;
        boolean notInBlockedFog = cameraSubmersionType != FogType.POWDER_SNOW && cameraSubmersionType != FogType.LAVA;
        return visibleUnderwater && notInBlockedFog;
    }

    protected boolean checkXRanges() {
        double playerX = Objects.requireNonNull(Minecraft.getInstance().player).getX();
        return Utils.checkRanges(playerX, this.conditions.getXRanges().entries(), this.conditions.getXRanges().excludes());
    }

    protected boolean checkYRanges() {
        double playerY = Objects.requireNonNull(Minecraft.getInstance().player).getY();
        return Utils.checkRanges(playerY, this.conditions.getYRanges().entries(), this.conditions.getYRanges().excludes());
    }

    protected boolean checkZRanges() {
        double playerZ = Objects.requireNonNull(Minecraft.getInstance().player).getZ();
        return Utils.checkRanges(playerZ, this.conditions.getZRanges().entries(), this.conditions.getZRanges().excludes());
    }

    protected boolean checkWeather() {
        ClientLevel world = Objects.requireNonNull(Minecraft.getInstance().level);
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        Biome.Precipitation precipitation = ((Biome)world.getBiome(player.blockPosition()).value()).getPrecipitationAt(player.blockPosition(), world.getSeaLevel());
        if (this.conditions.getWeathers().entries().isEmpty()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.WORLD_PRECIPITATION) && world.isRaining() && precipitation == Biome.Precipitation.NONE && !world.isThundering()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.WORLD_THUNDERSTORM) && world.isRaining() && world.isThundering() && precipitation == Biome.Precipitation.NONE) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.RAIN_IN_BIOME) && world.isRaining() && precipitation == Biome.Precipitation.RAIN && !world.isThundering()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.THUNDER_IN_RAIN_BIOME) && world.isRaining() && precipitation == Biome.Precipitation.RAIN && world.isThundering()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.SNOW_IN_BIOME) && world.isRaining() && precipitation == Biome.Precipitation.SNOW && !world.isThundering()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.THUNDER_IN_SNOW_BIOME) && world.isRaining() && precipitation == Biome.Precipitation.SNOW && world.isThundering()) {
            return true;
        }
        return this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.NO_PRECIPITATION) && !world.isRaining() && !world.isThundering();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Conditions getConditions() {
        return this.conditions;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int getLayer() {
        return this.properties.layer();
    }

    @Override
    public boolean isActive() {
        return this.getAlpha() != 0.0f;
    }

    public String toString() {
        return String.format("[layer=%s, alpha=%s, dimension=%s, world=%s, biomes=%s, xranges=%s, yranges=%s, zranges=%s, weather=%s, effects=%s]", this.getProperties().layer(), Float.valueOf(this.getAlpha()), this.checkDimensions(), this.checkWorlds(), this.checkBiomes(), this.checkXRanges(), this.checkYRanges(), this.checkZRanges(), this.checkWeather(), this.checkEffects());
    }
}

