/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox;

import java.util.Collection;
import java.util.Objects;
import me.flashyreese.mods.nuit.api.skyboxes.NuitSkybox;
import me.flashyreese.mods.nuit.api.skyboxes.Skybox;
import me.flashyreese.mods.nuit.components.Conditions;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class DefaultHandler {
    public static final ResourceLocation DEFAULT = ResourceLocation.tryBuild((String)"nuit", (String)"default");
    private static Conditions concatConditions = Conditions.of();

    public static void addConditions(Skybox skybox) {
        if (skybox instanceof NuitSkybox) {
            NuitSkybox nuitSkybox = (NuitSkybox)skybox;
            DefaultHandler.addConditions(nuitSkybox.getConditions());
        }
    }

    public static void addConditions(Conditions conditions) {
        for (ResourceLocation location : conditions.getBiomes().entries()) {
            if (concatConditions.getBiomes().entries().contains(location)) continue;
            concatConditions.getBiomes().entries().add(location);
        }
        for (ResourceLocation resourceLocation : conditions.getWorlds().entries()) {
            if (concatConditions.getWorlds().entries().contains(resourceLocation)) continue;
            concatConditions.getWorlds().entries().add(resourceLocation);
        }
        for (ResourceLocation resource : conditions.getDimensions().entries()) {
            if (concatConditions.getDimensions().entries().contains(resource)) continue;
            concatConditions.getDimensions().entries().add(resource);
        }
    }

    private static void clearConditions() {
        concatConditions = Conditions.of();
    }

    public static void clearConditionsExcept(Collection<Skybox> exceptions) {
        DefaultHandler.clearConditions();
        exceptions.forEach(DefaultHandler::addConditions);
    }

    public static boolean checkFallbackBiomes() {
        Minecraft client = Minecraft.getInstance();
        Objects.requireNonNull(client.level);
        Objects.requireNonNull(client.player);
        return !concatConditions.getBiomes().entries().contains(client.level.registryAccess().lookupOrThrow(Registries.BIOME).getKey((Object)((Biome)client.level.getBiome(client.player.blockPosition()).value())));
    }

    public static boolean checkFallbackWorlds() {
        Minecraft client = Minecraft.getInstance();
        Objects.requireNonNull(client.level);
        return !concatConditions.getWorlds().entries().contains(client.level.dimensionType().effectsLocation());
    }

    public static boolean checkFallbackDimensions() {
        Minecraft client = Minecraft.getInstance();
        Objects.requireNonNull(client.level);
        return !concatConditions.getDimensions().entries().contains(client.level.dimension().location());
    }
}

