/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Function;
import me.flashyreese.mods.nuit.components.Blend;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.components.RGBA;
import me.flashyreese.mods.nuit.mixin.RenderPipelinesAccessor;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.util.Utils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL46C;

public class MonoColorSkybox
extends AbstractSkybox {
    private static final Function<BlendFunction, RenderPipeline> MONO_COLOR_SKYBOX_PIPELINE_CONSUMER = blendFunction -> {
        RenderPipeline.Builder builder = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelinesAccessor.getMatricesColorSnippet()});
        builder.withLocation(ResourceLocation.tryBuild((String)"nuit", (String)"pipeline/mono_color_skybox"));
        builder.withVertexShader("core/position_color");
        builder.withFragmentShader("core/position_color");
        builder.withDepthWrite(false);
        if (blendFunction != null) {
            builder.withBlend(blendFunction);
        } else {
            builder.withoutBlend();
        }
        builder.withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS);
        return builder.build();
    };
    public static Codec<MonoColorSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.optionalFieldOf("properties", (Object)Properties.of()).forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.of()).forGetter(AbstractSkybox::getConditions), (App)RGBA.CODEC.optionalFieldOf("color", (Object)RGBA.of()).forGetter(MonoColorSkybox::getColor), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.normal()).forGetter(MonoColorSkybox::getBlend)).apply((Applicative)instance, MonoColorSkybox::new));
    public RGBA color;
    public Blend blend;
    private int indexCount = 0;
    private RenderSystem.AutoStorageIndexBuffer skyIndices;
    private GpuBuffer vertexBuffer = null;

    public MonoColorSkybox(Properties properties, Conditions conditions, RGBA color, Blend blend) {
        super(properties, conditions);
        this.color = color;
        this.blend = blend;
        this.buildSky();
    }

    private void buildSky() {
        VertexFormat vertexFormat = DefaultVertexFormat.POSITION_COLOR;
        VertexFormat.Mode vertexFormatMode = VertexFormat.Mode.QUADS;
        ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(vertexFormat.getVertexSize() * 24);
        BufferBuilder builder = new BufferBuilder(byteBufferBuilder, vertexFormatMode, vertexFormat);
        for (int face = 0; face < 6; ++face) {
            Matrix4f matrix4f = Utils.getMatrixForRotatedFace(face);
            builder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
            builder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
            builder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
            builder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
        }
        this.skyIndices = RenderSystem.getSequentialBuffer((VertexFormat.Mode)vertexFormatMode);
        try (MeshData meshData = builder.build();){
            if (meshData != null) {
                this.indexCount = meshData.drawState().indexCount();
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Mono color skybox", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.vertexBuffer());
            }
        }
    }

    @Override
    public void render(SkyRendererAccessor skyRendererAccess, PoseStack poseStack, float tickDelta, Camera camera, MultiBufferSource.BufferSource bufferSource, FogParameters fogParameters) {
        RenderSystem.setShaderFog((FogParameters)fogParameters);
        if (this.alpha > 0.0f && this.vertexBuffer != null) {
            Vector4f colorModifier = this.blend.applyEquationAndGetColor(this.alpha);
            RenderSystem.setShaderColor((float)colorModifier.x, (float)colorModifier.y, (float)colorModifier.z, (float)colorModifier.w);
            RenderPipeline pipeline = MONO_COLOR_SKYBOX_PIPELINE_CONSUMER.apply(this.blend.getBlendFunction());
            RenderTarget renderTarget = Minecraft.getInstance().getMainRenderTarget();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(renderTarget.getColorTexture(), OptionalInt.empty(), renderTarget.getDepthTexture(), OptionalDouble.empty());){
                renderPass.setPipeline(pipeline);
                renderPass.setVertexBuffer(0, this.vertexBuffer);
                renderPass.setIndexBuffer(this.skyIndices.getBuffer(this.indexCount), this.skyIndices.type());
                renderPass.drawIndexed(0, this.indexCount);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL46C.glBlendEquation((int)32774);
        }
    }

    public RGBA getColor() {
        return this.color;
    }

    public Blend getBlend() {
        return this.blend;
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

