/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.flashyreese.mods.nuit.api.skyboxes.Skybox;
import me.flashyreese.mods.nuit.skybox.MonoColorSkybox;
import me.flashyreese.mods.nuit.skybox.decorations.DecorationBox;
import me.flashyreese.mods.nuit.skybox.textured.MultiTexturedSkybox;
import me.flashyreese.mods.nuit.skybox.textured.SquareTexturedSkybox;
import me.flashyreese.mods.nuit.skybox.vanilla.EndSkybox;
import me.flashyreese.mods.nuit.skybox.vanilla.OverworldSkybox;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SkyboxType<T extends Skybox> {
    public static final Codec<ResourceLocation> SKYBOX_ID_CODEC;
    public static final ResourceKey<Registry<SkyboxType<? extends Skybox>>> SKYBOX_TYPE_REGISTRY_KEY;
    public static final SkyboxType<OverworldSkybox> OVERWORLD;
    public static final SkyboxType<EndSkybox> END;
    public static final SkyboxType<MonoColorSkybox> MONO_COLOR_SKYBOX;
    public static final SkyboxType<SquareTexturedSkybox> SQUARE_TEXTURED_SKYBOX;
    public static final SkyboxType<MultiTexturedSkybox> MULTI_TEXTURED_SKYBOX;
    public static final SkyboxType<DecorationBox> DECORATION_BOX;
    private static final Map<ResourceLocation, SkyboxType<?>> SKYBOX_TYPES;
    private final BiMap<Integer, Codec<T>> codecBiMap;
    private final ResourceLocation name;

    private SkyboxType(String name, int schemaVersion, Codec<T> codec) {
        this(ResourceLocation.tryBuild((String)"nuit", (String)name), schemaVersion, codec);
    }

    public SkyboxType(ResourceLocation name, int schemaVersion, Codec<T> codec) {
        this((BiMap<Integer, Codec<T>>)ImmutableBiMap.builder().put((Object)schemaVersion, codec).build(), name);
    }

    public SkyboxType(BiMap<Integer, Codec<T>> codecBiMap, ResourceLocation name) {
        this.codecBiMap = codecBiMap;
        this.name = name;
    }

    public static <T extends Skybox> SkyboxType<T> register(SkyboxType<T> type) {
        if (SKYBOX_TYPES.putIfAbsent(type.name, type) != null) {
            throw new IllegalStateException("SkyboxType with name '" + String.valueOf(type.name) + "' already registered!");
        }
        return type;
    }

    public static void registerAll(Consumer<SkyboxType<?>> function) {
        SKYBOX_TYPES.values().forEach(function);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public Codec<T> getCodec(int schemaVersion) {
        return Objects.requireNonNull((Codec)this.codecBiMap.get((Object)schemaVersion), String.format("Unsupported schema version '%d' for skybox type %s", schemaVersion, this.name));
    }

    static {
        SKYBOX_TYPE_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.tryBuild((String)"nuit", (String)"skybox_type"));
        SKYBOX_TYPES = new ConcurrentHashMap();
        SKYBOX_ID_CODEC = Codec.STRING.xmap(s -> {
            if (!s.contains(":")) {
                return ResourceLocation.tryBuild((String)"nuit", (String)s);
            }
            return ResourceLocation.tryParse((String)s);
        }, id -> {
            if (id.getNamespace().equals("nuit")) {
                return id.getPath();
            }
            return id.toString();
        });
        OVERWORLD = SkyboxType.register(new SkyboxType<OverworldSkybox>("overworld", 1, OverworldSkybox.CODEC));
        END = SkyboxType.register(new SkyboxType<EndSkybox>("end", 1, EndSkybox.CODEC));
        MONO_COLOR_SKYBOX = SkyboxType.register(new SkyboxType<MonoColorSkybox>("monocolor", 1, MonoColorSkybox.CODEC));
        SQUARE_TEXTURED_SKYBOX = SkyboxType.register(new SkyboxType<SquareTexturedSkybox>("square-textured", 1, SquareTexturedSkybox.CODEC));
        MULTI_TEXTURED_SKYBOX = SkyboxType.register(new SkyboxType<MultiTexturedSkybox>("multi-textured", 1, MultiTexturedSkybox.CODEC));
        DECORATION_BOX = SkyboxType.register(new SkyboxType<DecorationBox>("decorations", 1, DecorationBox.CODEC));
    }
}

