/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox.decorations;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import me.flashyreese.mods.nuit.components.Blend;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.util.OverrideUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL46C;

public class DecorationBox
extends AbstractSkybox {
    public static Codec<DecorationBox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.optionalFieldOf("properties", (Object)Properties.decorations()).forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.of()).forGetter(AbstractSkybox::getConditions), (App)ResourceLocation.CODEC.optionalFieldOf("sun", (Object)SkyRendererAccessor.getSun()).forGetter(DecorationBox::getSunTexture), (App)ResourceLocation.CODEC.optionalFieldOf("moon", (Object)SkyRendererAccessor.getMoonPhases()).forGetter(DecorationBox::getMoonTexture), (App)Codec.BOOL.optionalFieldOf("showSun", (Object)false).forGetter(DecorationBox::isSunEnabled), (App)Codec.BOOL.optionalFieldOf("showMoon", (Object)false).forGetter(DecorationBox::isMoonEnabled), (App)Codec.BOOL.optionalFieldOf("showStars", (Object)false).forGetter(DecorationBox::isStarsEnabled), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.decorations()).forGetter(DecorationBox::getBlend)).apply((Applicative)instance, DecorationBox::new));
    private final ResourceLocation sunTexture;
    private final ResourceLocation moonTexture;
    private final boolean sunEnabled;
    private final boolean moonEnabled;
    private final boolean starsEnabled;
    private final Blend blend;

    public DecorationBox(Properties properties, Conditions conditions, ResourceLocation sun, ResourceLocation moon, boolean sunEnabled, boolean moonEnabled, boolean starsEnabled, Blend blend) {
        this.properties = properties;
        this.conditions = conditions;
        this.sunTexture = sun;
        this.moonTexture = moon;
        this.sunEnabled = sunEnabled;
        this.moonEnabled = moonEnabled;
        this.starsEnabled = starsEnabled;
        this.blend = blend;
    }

    @Override
    public void render(SkyRendererAccessor skyRendererAccessor, PoseStack poseStack, float tickDelta, Camera camera, MultiBufferSource.BufferSource bufferSource, FogParameters fogParameters) {
        RenderSystem.setShaderFog((FogParameters)fogParameters);
        ClientLevel level = Objects.requireNonNull((ClientLevel)camera.getEntity().level());
        OverrideUtils.enableBlendingOverride(this.blend.getBlendFunction());
        Vector4f colorModifier = this.blend.applyEquationAndGetColor(this.alpha);
        RenderSystem.setShaderColor((float)colorModifier.x, (float)colorModifier.y, (float)colorModifier.z, (float)colorModifier.w);
        poseStack.pushPose();
        this.properties.rotation().apply(poseStack, level);
        if (this.sunEnabled) {
            this.renderSun((MultiBufferSource)bufferSource, poseStack);
        }
        if (this.moonEnabled) {
            this.renderMoon(level.getMoonPhase(), (MultiBufferSource)bufferSource, poseStack);
        }
        if (this.sunEnabled || this.moonEnabled) {
            bufferSource.endBatch();
        }
        if (this.starsEnabled) {
            skyRendererAccessor.invokeRenderStars(fogParameters, level.getStarBrightness(tickDelta), poseStack);
        }
        poseStack.popPose();
        OverrideUtils.disableBlendingOverride();
        GL46C.glBlendEquation((int)32774);
    }

    public void renderSun(MultiBufferSource multiBufferSource, PoseStack poseStack) {
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.celestial((ResourceLocation)this.sunTexture));
        int i = ARGB.white((float)1.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        vertexConsumer.addVertex(matrix4f, -30.0f, 100.0f, -30.0f).setUv(0.0f, 0.0f).setColor(i);
        vertexConsumer.addVertex(matrix4f, 30.0f, 100.0f, -30.0f).setUv(1.0f, 0.0f).setColor(i);
        vertexConsumer.addVertex(matrix4f, 30.0f, 100.0f, 30.0f).setUv(1.0f, 1.0f).setColor(i);
        vertexConsumer.addVertex(matrix4f, -30.0f, 100.0f, 30.0f).setUv(0.0f, 1.0f).setColor(i);
    }

    public void renderMoon(int moonPhase, MultiBufferSource multiBufferSource, PoseStack poseStack) {
        int xCoord = moonPhase % 4;
        int yCoord = moonPhase / 4 % 2;
        float startX = (float)xCoord / 4.0f;
        float startY = (float)yCoord / 2.0f;
        float endX = (float)(xCoord + 1) / 4.0f;
        float endY = (float)(yCoord + 1) / 2.0f;
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.celestial((ResourceLocation)this.moonTexture));
        int p = ARGB.white((float)1.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        vertexConsumer.addVertex(matrix4f, -20.0f, -100.0f, 20.0f).setUv(endX, endY).setColor(p);
        vertexConsumer.addVertex(matrix4f, 20.0f, -100.0f, 20.0f).setUv(startX, endY).setColor(p);
        vertexConsumer.addVertex(matrix4f, 20.0f, -100.0f, -20.0f).setUv(startX, startY).setColor(p);
        vertexConsumer.addVertex(matrix4f, -20.0f, -100.0f, -20.0f).setUv(endX, startY).setColor(p);
    }

    public ResourceLocation getSunTexture() {
        return this.sunTexture;
    }

    public ResourceLocation getMoonTexture() {
        return this.moonTexture;
    }

    public boolean isSunEnabled() {
        return this.sunEnabled;
    }

    public boolean isMoonEnabled() {
        return this.moonEnabled;
    }

    public boolean isStarsEnabled() {
        return this.starsEnabled;
    }

    public Blend getBlend() {
        return this.blend;
    }

    @Override
    public void close() {
    }
}

