/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.flashyreese.mods.nuit.api.NuitApi;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.skybox.decorations.DecorationBox;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SkyRenderer;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class OverworldSkybox
extends AbstractSkybox {
    public static Codec<OverworldSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.optionalFieldOf("properties", (Object)Properties.of()).forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.of()).forGetter(AbstractSkybox::getConditions)).apply((Applicative)instance, OverworldSkybox::new));

    public OverworldSkybox(Properties properties, Conditions conditions) {
        super(properties, conditions);
    }

    @Override
    public void render(SkyRendererAccessor skyRendererAccessor, PoseStack poseStack, float tickDelta, Camera camera, MultiBufferSource.BufferSource bufferSource, FogParameters fogParameters) {
        double eyeHeight;
        RenderSystem.setShaderFog((FogParameters)fogParameters);
        ClientLevel level = (ClientLevel)camera.getEntity().level();
        float sunAngle = level.getSunAngle(tickDelta);
        float timeOfDay = level.getTimeOfDay(tickDelta);
        int sunriseOrSunsetColor = level.effects().getSunriseOrSunsetColor(timeOfDay);
        int skyColor = level.getSkyColor(camera.getPosition(), tickDelta);
        ((SkyRenderer)skyRendererAccessor).renderSkyDisc(ARGB.redFloat((int)skyColor), ARGB.greenFloat((int)skyColor), ARGB.blueFloat((int)skyColor));
        if (level.effects().isSunriseOrSunset(timeOfDay)) {
            if (NuitApi.getInstance().getActiveSkyboxes().stream().anyMatch(skybox -> {
                DecorationBox decorationBox;
                return skybox instanceof DecorationBox && (decorationBox = (DecorationBox)skybox).getProperties().rotation().skyboxRotation();
            })) {
                sunAngle = Mth.positiveModulo((float)((float)level.getDayTime() / 24000.0f + 0.75f), (float)1.0f);
            }
            this.renderSunriseAndSunset(poseStack, bufferSource, sunAngle, sunriseOrSunsetColor);
        }
        if ((eyeHeight = camera.getEntity().getEyePosition((float)tickDelta).y - level.getLevelData().getHorizonHeight((LevelHeightAccessor)level)) < 0.0) {
            ((SkyRenderer)skyRendererAccessor).renderDarkDisc();
        }
    }

    private void renderSunriseAndSunset(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float sunAngle, int sunriseOrSunsetColor) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        float zRotation = Mth.sin((float)sunAngle) < 0.0f ? 180.0f : 0.0f;
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(zRotation));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
        Matrix4f transformationMatrix = poseStack.last().pose();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.sunriseSunset());
        float alpha = ARGB.alphaFloat((int)sunriseOrSunsetColor) * this.alpha;
        vertexConsumer.addVertex(transformationMatrix, 0.0f, 100.0f, 0.0f).setColor(sunriseOrSunsetColor);
        int transparentColor = ARGB.transparent((int)sunriseOrSunsetColor);
        for (int i = 0; i <= 16; ++i) {
            float angleRadians = (float)i * ((float)Math.PI * 2) / 16.0f;
            float x = Mth.sin((float)angleRadians);
            float y = Mth.cos((float)angleRadians);
            float z = -y * 40.0f * alpha;
            vertexConsumer.addVertex(transformationMatrix, x * 120.0f, y * 120.0f, z).setColor(transparentColor);
        }
        bufferSource.endBatch();
        poseStack.popPose();
    }

    @Override
    public void close() {
    }
}

