/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.flashyreese.mods.nuit.NuitClient;
import me.flashyreese.mods.nuit.api.NuitApi;
import me.flashyreese.mods.nuit.api.NuitPlatformHelper;
import me.flashyreese.mods.nuit.api.skyboxes.Skybox;
import me.flashyreese.mods.nuit.components.Metadata;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.DefaultHandler;
import me.flashyreese.mods.nuit.skybox.SkyboxType;
import me.flashyreese.mods.nuit.skybox.TextureRegistrar;
import net.minecraft.class_1049;
import net.minecraft.class_10537;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_9958;
import org.jetbrains.annotations.ApiStatus;

public class SkyboxManager
implements NuitApi {
    private static final SkyboxManager INSTANCE = new SkyboxManager();
    private final List<class_2960> preloadedTextures = new ArrayList<class_2960>();
    private final Map<class_2960, Skybox> skyboxMap = new Object2ObjectLinkedOpenHashMap();
    private final Map<class_2960, Skybox> permanentSkyboxMap = new Object2ObjectLinkedOpenHashMap();
    private final List<Skybox> activeSkyboxes = new LinkedList<Skybox>();
    private Skybox currentSkybox = null;
    private boolean enabled = true;

    public static Optional<Skybox> parseSkyboxJson(class_2960 resourceLocation, JsonObject jsonObject) {
        Metadata metadata;
        try {
            metadata = (Metadata)((Pair)Metadata.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow()).getFirst();
        }
        catch (RuntimeException e) {
            NuitClient.getLogger().warn("Skipping invalid skybox {}", (Object)resourceLocation.toString(), (Object)e);
            NuitClient.getLogger().warn(jsonObject.toString());
            return Optional.empty();
        }
        Optional optionalType = NuitPlatformHelper.INSTANCE.getSkyboxTypeRegistry().method_10223(metadata.type());
        if (optionalType.isEmpty()) {
            NuitClient.getLogger().warn("Skipping skybox {} with unknown type {}", (Object)resourceLocation.toString(), (Object)metadata.type().method_12832().replace('_', '-'));
            return Optional.empty();
        }
        class_6880.class_6883 type = (class_6880.class_6883)optionalType.get();
        try {
            return Optional.of((Skybox)((Pair)((SkyboxType)type.comp_349()).getCodec(metadata.schemaVersion()).decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow()).getFirst());
        }
        catch (RuntimeException e) {
            NuitClient.getLogger().warn("Skipping invalid skybox {}", (Object)resourceLocation.toString(), (Object)e);
            NuitClient.getLogger().warn(jsonObject.toString());
            return Optional.empty();
        }
    }

    public static SkyboxManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void addSkybox(class_2960 resourceLocation, JsonObject jsonObject) {
        Optional<Skybox> skybox = SkyboxManager.parseSkyboxJson(resourceLocation, jsonObject);
        if (skybox.isPresent()) {
            NuitClient.getLogger().info("Adding skybox {}", (Object)resourceLocation.toString());
            this.addSkybox(resourceLocation, skybox.get());
        }
    }

    @Override
    public void addSkybox(class_2960 resourceLocation, Skybox skybox) {
        Preconditions.checkNotNull((Object)resourceLocation, (Object)"Identifier was null");
        Preconditions.checkNotNull((Object)skybox, (Object)"Skybox was null");
        DefaultHandler.addConditions(skybox);
        if (skybox instanceof TextureRegistrar) {
            TextureRegistrar textureRegistrar = (TextureRegistrar)((Object)skybox);
            textureRegistrar.getTexturesToRegister().forEach(theResourceLocation -> {
                class_310.method_1551().method_1531().method_65876(theResourceLocation, (class_10537)new class_1049(theResourceLocation));
                this.preloadedTextures.add((class_2960)theResourceLocation);
            });
        }
        this.skyboxMap.put(resourceLocation, skybox);
    }

    @Override
    public void addPermanentSkybox(class_2960 resourceLocation, Skybox skybox) {
        Preconditions.checkNotNull((Object)resourceLocation, (Object)"Identifier was null");
        Preconditions.checkNotNull((Object)skybox, (Object)"Skybox was null");
        DefaultHandler.addConditions(skybox);
        this.permanentSkyboxMap.put(resourceLocation, skybox);
    }

    @Override
    @ApiStatus.Internal
    public void clearSkyboxes() {
        DefaultHandler.clearConditionsExcept(this.permanentSkyboxMap.values());
        this.activeSkyboxes.forEach(skybox -> {
            try {
                skybox.close();
            }
            catch (Exception e) {
                NuitClient.getLogger().warn("Error while closing active skybox", (Throwable)e);
            }
        });
        this.skyboxMap.clear();
        this.activeSkyboxes.clear();
        this.preloadedTextures.forEach(texture -> class_310.method_1551().method_1531().method_4615(texture));
        this.preloadedTextures.clear();
    }

    @ApiStatus.Internal
    public void renderSkyboxes(SkyRendererAccessor skyRendererAccessor, class_4587 poseStack, float tickDelta, class_4184 camera, class_4597.class_4598 bufferSource, class_9958 fogParameters) {
        Iterator<Skybox> iterator = this.activeSkyboxes.iterator();
        while (iterator.hasNext()) {
            Skybox skybox;
            this.currentSkybox = skybox = iterator.next();
            skybox.render(skyRendererAccessor, poseStack, tickDelta, camera, bufferSource, fogParameters);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Skybox getCurrentSkybox() {
        return this.currentSkybox;
    }

    @Override
    public List<Skybox> getActiveSkyboxes() {
        return this.activeSkyboxes;
    }

    public void tick(class_638 level) {
        for (Skybox skybox2 : Iterables.concat(this.skyboxMap.values(), this.permanentSkyboxMap.values())) {
            skybox2.tick(level);
        }
        this.activeSkyboxes.removeIf(skybox -> !skybox.isActive());
        for (Skybox skybox2 : Iterables.concat(this.skyboxMap.values(), this.permanentSkyboxMap.values())) {
            if (this.activeSkyboxes.contains(skybox2) || !skybox2.isActive()) continue;
            this.activeSkyboxes.add(skybox2);
        }
        this.activeSkyboxes.sort(Comparator.comparingInt(Skybox::getLayer));
    }

    public Map<class_2960, Skybox> getSkyboxMap() {
        return this.skyboxMap;
    }
}

