/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.components;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import me.flashyreese.mods.nuit.NuitClient;
import me.flashyreese.mods.nuit.components.Blender;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL46C;

public class Blend {
    public static Codec<Blend> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("type", (Object)"").forGetter(Blend::getType), (App)Blender.CODEC.optionalFieldOf("blender", (Object)Blender.normal()).forGetter(Blend::getBlender)).apply((Applicative)instance, Blend::new));
    private final String type;
    private final Blender blender;
    private final BlendFunction blendFunction;
    private final Function<Float, Vector4f> colorAndEquationFunc;

    public Blend(String type, Blender blender) {
        this.type = type;
        this.blender = blender;
        switch (type) {
            case "add": {
                this.blendFunction = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE);
                this.colorAndEquationFunc = alpha -> {
                    GL46C.glBlendEquation((int)Blender.Equation.ADD.value);
                    return new Vector4f(1.0f, 1.0f, 1.0f, alpha.floatValue());
                };
                break;
            }
            case "subtract": {
                this.blendFunction = new BlendFunction(SourceFactor.ONE_MINUS_DST_COLOR, DestFactor.ZERO);
                this.colorAndEquationFunc = alpha -> {
                    GL46C.glBlendEquation((int)Blender.Equation.ADD.value);
                    return new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), 1.0f);
                };
                break;
            }
            case "multiply": {
                this.blendFunction = new BlendFunction(SourceFactor.DST_COLOR, DestFactor.ONE_MINUS_SRC_ALPHA);
                this.colorAndEquationFunc = alpha -> {
                    GL46C.glBlendEquation((int)Blender.Equation.ADD.value);
                    return new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), alpha.floatValue());
                };
                break;
            }
            case "screen": {
                this.blendFunction = new BlendFunction(SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_COLOR);
                this.colorAndEquationFunc = alpha -> {
                    GL46C.glBlendEquation((int)Blender.Equation.ADD.value);
                    return new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), 1.0f);
                };
                break;
            }
            case "replace": {
                this.blendFunction = new BlendFunction(SourceFactor.ZERO, DestFactor.ONE);
                this.colorAndEquationFunc = alpha -> {
                    GL46C.glBlendEquation((int)Blender.Equation.ADD.value);
                    return new Vector4f(1.0f, 1.0f, 1.0f, alpha.floatValue());
                };
                break;
            }
            case "normal": {
                this.blendFunction = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA);
                this.colorAndEquationFunc = alpha -> {
                    GL46C.glBlendEquation((int)Blender.Equation.ADD.value);
                    return new Vector4f(1.0f, 1.0f, 1.0f, alpha.floatValue());
                };
                break;
            }
            case "burn": {
                this.blendFunction = new BlendFunction(SourceFactor.ZERO, DestFactor.ONE_MINUS_SRC_COLOR);
                this.colorAndEquationFunc = alpha -> {
                    GL46C.glBlendEquation((int)Blender.Equation.ADD.value);
                    return new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), 1.0f);
                };
                break;
            }
            case "dodge": {
                this.blendFunction = new BlendFunction(SourceFactor.DST_COLOR, DestFactor.ONE);
                this.colorAndEquationFunc = alpha -> {
                    GL46C.glBlendEquation((int)Blender.Equation.ADD.value);
                    return new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), 1.0f);
                };
                break;
            }
            case "disable": {
                this.blendFunction = null;
                this.colorAndEquationFunc = alpha -> new Vector4f(1.0f, 1.0f, 1.0f, alpha.floatValue());
                break;
            }
            case "decorations": {
                this.blendFunction = Blender.decorations().getBlendFunction();
                this.colorAndEquationFunc = Blender.decorations()::applyEquationAndGetColor;
                break;
            }
            case "custom": {
                this.blendFunction = this.blender.getBlendFunction();
                this.colorAndEquationFunc = this.blender::applyEquationAndGetColor;
                break;
            }
            default: {
                NuitClient.getLogger().error("Blend mode is set to an invalid or unsupported value.");
                this.blendFunction = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
                this.colorAndEquationFunc = alpha -> new Vector4f(1.0f, 1.0f, 1.0f, alpha.floatValue());
            }
        }
    }

    public static Blend normal() {
        return new Blend("", Blender.normal());
    }

    public static Blend decorations() {
        return new Blend("decorations", Blender.decorations());
    }

    public Vector4f applyEquationAndGetColor(float alpha) {
        return this.colorAndEquationFunc.apply(Float.valueOf(alpha));
    }

    @Nullable
    public BlendFunction getBlendFunction() {
        return this.blendFunction;
    }

    public String getType() {
        return this.type;
    }

    public Blender getBlender() {
        return this.blender;
    }
}

