/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.components;

import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.function.Function;
import me.flashyreese.mods.nuit.NuitClient;
import me.flashyreese.mods.nuit.util.Utils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL46C;

public class Blender {
    public static Codec<Blender> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("separateFunction", (Object)false).forGetter(Blender::isSeparateFunction), (App)Codec.INT.optionalFieldOf("sourceFactor", (Object)770).forGetter(Blender::getSourceFactor), (App)Codec.INT.optionalFieldOf("destinationFactor", (Object)1).forGetter(Blender::getDestinationFactor), (App)Codec.INT.optionalFieldOf("equation", (Object)32774).forGetter(Blender::getEquation), (App)Codec.INT.optionalFieldOf("sourceFactorAlpha", (Object)0).forGetter(Blender::getSourceFactorAlpha), (App)Codec.INT.optionalFieldOf("destinationFactorAlpha", (Object)0).forGetter(Blender::getDestinationFactorAlpha), (App)Codec.BOOL.optionalFieldOf("redAlphaEnabled", (Object)false).forGetter(Blender::isRedAlphaEnabled), (App)Codec.BOOL.optionalFieldOf("greenAlphaEnabled", (Object)false).forGetter(Blender::isGreenAlphaEnabled), (App)Codec.BOOL.optionalFieldOf("blueAlphaEnabled", (Object)false).forGetter(Blender::isBlueAlphaEnabled), (App)Codec.BOOL.optionalFieldOf("alphaEnabled", (Object)true).forGetter(Blender::isAlphaEnabled)).apply((Applicative)instance, Blender::new));
    private final boolean separateFunction;
    private final int sourceFactor;
    private final int destinationFactor;
    private final int equation;
    private final int sourceFactorAlpha;
    private final int destinationFactorAlpha;
    private final boolean redAlphaEnabled;
    private final boolean greenAlphaEnabled;
    private final boolean blueAlphaEnabled;
    private final boolean alphaEnabled;
    private final BlendFunction blendFunction;
    private final Function<Float, Vector4f> colorAndEquationFunc;

    public Blender(boolean separateFunction, int sourceFactor, int destinationFactor, int equation, int sourceFactorAlpha, int destinationFactorAlpha, boolean redAlphaEnabled, boolean greenAlphaEnabled, boolean blueAlphaEnabled, boolean alphaEnabled) {
        this.separateFunction = separateFunction;
        this.sourceFactor = sourceFactor;
        this.destinationFactor = destinationFactor;
        this.equation = equation;
        this.sourceFactorAlpha = sourceFactorAlpha;
        this.destinationFactorAlpha = destinationFactorAlpha;
        this.redAlphaEnabled = redAlphaEnabled;
        this.greenAlphaEnabled = greenAlphaEnabled;
        this.blueAlphaEnabled = blueAlphaEnabled;
        this.alphaEnabled = alphaEnabled;
        if (this.separateFunction && this.isValidFactor(sourceFactor) && this.isValidFactor(destinationFactor) && this.isValidFactor(sourceFactorAlpha) && this.isValidFactor(destinationFactorAlpha) && this.isValidEquation(equation) || this.isValidFactor(sourceFactor) && this.isValidFactor(destinationFactor) && this.isValidEquation(equation)) {
            this.blendFunction = this.separateFunction ? new BlendFunction(Utils.toSourceFactor(this.sourceFactor), Utils.toDestFactor(this.destinationFactor), Utils.toSourceFactor(this.sourceFactorAlpha), Utils.toDestFactor(this.destinationFactorAlpha)) : new BlendFunction(Utils.toSourceFactor(this.sourceFactor), Utils.toDestFactor(this.destinationFactor));
            this.colorAndEquationFunc = alpha -> {
                GL46C.glBlendEquation((int)this.equation);
                return new Vector4f(this.redAlphaEnabled ? alpha.floatValue() : 1.0f, this.greenAlphaEnabled ? alpha.floatValue() : 1.0f, this.blueAlphaEnabled ? alpha.floatValue() : 1.0f, this.alphaEnabled ? alpha.floatValue() : 1.0f);
            };
        } else {
            if (NuitClient.config().generalSettings.debugMode) {
                NuitClient.getLogger().error("Invalid custom blender values!");
            }
            this.blendFunction = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
            this.colorAndEquationFunc = alpha -> new Vector4f(1.0f, 1.0f, 1.0f, alpha.floatValue());
        }
    }

    public static Blender normal() {
        return new Blender(false, 770, 1, Equation.ADD.value, 0, 0, false, false, false, true);
    }

    public static Blender decorations() {
        return new Blender(true, 770, 1, Equation.ADD.value, 1, 0, false, false, false, true);
    }

    public Vector4f applyEquationAndGetColor(float alpha) {
        return this.colorAndEquationFunc.apply(Float.valueOf(alpha));
    }

    @Nullable
    public BlendFunction getBlendFunction() {
        return this.blendFunction;
    }

    public boolean isSeparateFunction() {
        return this.separateFunction;
    }

    public int getSourceFactor() {
        return this.sourceFactor;
    }

    public int getDestinationFactor() {
        return this.destinationFactor;
    }

    public int getEquation() {
        return this.equation;
    }

    public int getSourceFactorAlpha() {
        return this.sourceFactorAlpha;
    }

    public int getDestinationFactorAlpha() {
        return this.destinationFactorAlpha;
    }

    public boolean isRedAlphaEnabled() {
        return this.redAlphaEnabled;
    }

    public boolean isGreenAlphaEnabled() {
        return this.greenAlphaEnabled;
    }

    public boolean isBlueAlphaEnabled() {
        return this.blueAlphaEnabled;
    }

    public boolean isAlphaEnabled() {
        return this.alphaEnabled;
    }

    public boolean isValidFactor(int factor) {
        return Arrays.stream(SourceFactor.values()).filter(factor1 -> factor == GlConst.toGl((SourceFactor)factor1)).count() == 1L;
    }

    public boolean isValidEquation(int equation) {
        return Arrays.stream(Equation.values()).filter(equation1 -> equation == equation1.value).count() == 1L;
    }

    public static enum Equation {
        ADD(32774),
        SUBTRACT(32778),
        REVERSE_SUBTRACT(32779),
        MIN(32775),
        MAX(32776);

        public final int value;

        private Equation(int value) {
            this.value = value;
        }
    }
}

