/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import me.flashyreese.mods.nuit.NuitClient;
import me.flashyreese.mods.nuit.SkyboxManager;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;

public class NuitConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    public final GeneralSettings generalSettings = new GeneralSettings();
    private final KeyBindingImpl keyBinding = new KeyBindingImpl();
    private File file;

    public static NuitConfig load(File file) {
        NuitConfig config;
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                config = (NuitConfig)GSON.fromJson((Reader)reader, NuitConfig.class);
            }
            catch (Exception e) {
                NuitClient.getLogger().error("Could not parse config, falling back to defaults!", (Throwable)e);
                config = new NuitConfig();
            }
        } else {
            config = new NuitConfig();
        }
        config.file = file;
        config.save();
        return config;
    }

    public KeyBindingImpl getKeyBinding() {
        return this.keyBinding;
    }

    public void save() {
        File dir = this.file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save configuration file", e);
        }
    }

    public static class GeneralSettings {
        public boolean enable = true;
        public int unexpectedTransitionDuration = 20;
        public long fadeCacheDuration = 24000L;
        public boolean debugMode = false;
        public boolean debugHud = false;
    }

    public static class KeyBindingImpl {
        public final class_304 toggleNuit = new class_304("key.nuit.toggle", class_3675.class_307.field_1668, -1, "category.nuit");
        public final class_304 toggleSkyboxDebugHud = new class_304("key.nuit.toggle.debug_hud", class_3675.class_307.field_1668, -1, "category.nuit");

        public void tick(class_310 client) {
            while (this.toggleNuit.method_1436()) {
                NuitClient.config().generalSettings.enable = !NuitClient.config().generalSettings.enable;
                NuitClient.config().save();
                SkyboxManager.getInstance().setEnabled(NuitClient.config().generalSettings.enable);
                class_746 player = Objects.requireNonNull(client.field_1724);
                if (SkyboxManager.getInstance().isEnabled()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"nuit.message.enabled"), false);
                    continue;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"nuit.message.disabled"), false);
            }
            while (this.toggleSkyboxDebugHud.method_1436()) {
                NuitClient.config().generalSettings.debugHud = !NuitClient.config().generalSettings.debugHud;
                NuitClient.config().save();
            }
        }
    }
}

