/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import java.util.Map;
import java.util.Objects;
import me.flashyreese.mods.nuit.NuitClient;
import me.flashyreese.mods.nuit.api.skyboxes.NuitSkybox;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.components.Weather;
import me.flashyreese.mods.nuit.skybox.DefaultHandler;
import me.flashyreese.mods.nuit.util.Utils;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_5321;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7924;

public abstract class AbstractSkybox
implements NuitSkybox {
    private final Map<Long, Float> cachedKeyFrames = new Long2FloatOpenHashMap();
    public transient float alpha;
    protected Properties properties = Properties.of();
    protected Conditions conditions = Conditions.of();
    protected boolean unexpectedConditionTransition = false;
    protected long lastTime = -2L;
    protected float conditionAlpha = 0.0f;

    protected AbstractSkybox() {
    }

    protected AbstractSkybox(Properties properties, Conditions conditions) {
        this.properties = properties;
        this.conditions = conditions;
    }

    @Override
    public void tick(class_638 level) {
        this.updateAlpha(level);
    }

    @Override
    public void updateAlpha(class_638 level) {
        long currentTime = level.method_8532() % this.properties.fade().duration();
        boolean condition = this.checkConditions();
        float fadeAlpha = 1.0f;
        if (this.properties.fade().keyFrames().isEmpty()) {
            this.conditionAlpha = Utils.calculateConditionAlphaValue(1.0f, 0.0f, this.conditionAlpha, condition ? this.properties.transitionInDuration() : this.properties.transitionOutDuration(), condition);
        } else {
            if (this.properties.fade().duration() <= NuitClient.config().generalSettings.fadeCacheDuration) {
                fadeAlpha = this.cachedKeyFrames.computeIfAbsent(currentTime, time -> {
                    class_3545<Long, Long> keyFrames = Utils.findClosestKeyframes(this.properties.fade().keyFrames(), time).orElseThrow();
                    return Float.valueOf(Utils.calculateInterpolatedAlpha(time, this.properties.fade().duration(), (Long)keyFrames.method_15442(), (Long)keyFrames.method_15441(), this.properties.fade().keyFrames().get(keyFrames.method_15442()).floatValue(), this.properties.fade().keyFrames().get(keyFrames.method_15441()).floatValue()));
                }).floatValue();
            } else {
                class_3545<Long, Long> keyFrames = Utils.findClosestKeyframes(this.properties.fade().keyFrames(), currentTime).orElseThrow();
                fadeAlpha = Utils.calculateInterpolatedAlpha(currentTime, this.properties.fade().duration(), (Long)keyFrames.method_15442(), (Long)keyFrames.method_15441(), this.properties.fade().keyFrames().get(keyFrames.method_15442()).floatValue(), this.properties.fade().keyFrames().get(keyFrames.method_15441()).floatValue());
            }
            if (!(this.lastTime != currentTime - 1L && this.lastTime != currentTime || this.unexpectedConditionTransition)) {
                this.conditionAlpha = Utils.calculateConditionAlphaValue(1.0f, 0.0f, this.conditionAlpha, condition ? this.properties.transitionInDuration() : this.properties.transitionOutDuration(), condition);
            } else {
                this.unexpectedConditionTransition = true;
                this.conditionAlpha = Utils.calculateConditionAlphaValue(1.0f, 0.0f, this.conditionAlpha, NuitClient.config().generalSettings.unexpectedTransitionDuration, condition);
                if (this.unexpectedConditionTransition && (this.conditionAlpha == 0.0f || this.conditionAlpha == 1.0f)) {
                    this.unexpectedConditionTransition = false;
                }
            }
        }
        this.alpha = fadeAlpha * this.conditionAlpha;
        this.lastTime = currentTime;
    }

    protected boolean checkConditions() {
        return this.checkDimensions() && this.checkWorlds() && this.checkBiomes() && this.checkXRanges() && this.checkYRanges() && this.checkZRanges() && this.checkWeather() && this.checkEffects() && this.checkProperties();
    }

    protected boolean checkBiomes() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        Objects.requireNonNull(client.field_1724);
        return this.conditions.getBiomes().entries().isEmpty() || this.conditions.getBiomes().excludes() ^ (this.conditions.getBiomes().entries().contains(((class_5321)client.field_1687.method_23753(client.field_1724.method_24515()).method_40230().orElseThrow()).method_29177()) || this.conditions.getBiomes().entries().contains(DefaultHandler.DEFAULT) && DefaultHandler.checkFallbackBiomes());
    }

    protected boolean checkDimensions() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        return this.conditions.getDimensions().entries().isEmpty() || this.conditions.getDimensions().excludes() ^ (this.conditions.getDimensions().entries().contains(client.field_1687.method_27983().method_29177()) || this.conditions.getDimensions().entries().contains(DefaultHandler.DEFAULT) && DefaultHandler.checkFallbackDimensions());
    }

    protected boolean checkWorlds() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        return this.conditions.getWorlds().entries().isEmpty() || this.conditions.getWorlds().excludes() ^ (this.conditions.getWorlds().entries().contains(client.field_1687.method_8597().comp_655()) || this.conditions.getWorlds().entries().contains(DefaultHandler.DEFAULT) && DefaultHandler.checkFallbackWorlds());
    }

    protected boolean checkEffects() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        class_4184 camera = client.field_1773.method_19418();
        if (this.conditions.getEffects().entries().isEmpty()) {
            class_1309 livingEntity;
            class_1297 class_12972 = camera.method_19331();
            return !(class_12972 instanceof class_1309) || !(livingEntity = (class_1309)class_12972).method_6059(class_1294.field_5919) && !livingEntity.method_6059(class_1294.field_38092);
        }
        class_1297 class_12973 = camera.method_19331();
        if (class_12973 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12973;
            return this.conditions.getEffects().excludes() ^ this.conditions.getEffects().entries().stream().noneMatch(resourceLocation -> client.field_1687.method_30349().method_30530(class_7924.field_41208).method_10223(resourceLocation).isPresent() && livingEntity.method_6059(client.field_1687.method_30349().method_30530(class_7924.field_41208).method_47983((Object)((class_1291)((class_6880.class_6883)client.field_1687.method_30349().method_30530(class_7924.field_41208).method_10223(resourceLocation).get()).comp_349()))));
        }
        return true;
    }

    protected boolean checkProperties() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        class_4184 camera = client.field_1773.method_19418();
        class_5636 cameraSubmersionType = camera.method_19334();
        boolean visibleUnderwater = this.properties.visibleUnderwater() || cameraSubmersionType != class_5636.field_27886;
        boolean notInBlockedFog = cameraSubmersionType != class_5636.field_27887 && cameraSubmersionType != class_5636.field_27885;
        return visibleUnderwater && notInBlockedFog;
    }

    protected boolean checkXRanges() {
        double playerX = Objects.requireNonNull(class_310.method_1551().field_1724).method_23317();
        return Utils.checkRanges(playerX, this.conditions.getXRanges().entries(), this.conditions.getXRanges().excludes());
    }

    protected boolean checkYRanges() {
        double playerY = Objects.requireNonNull(class_310.method_1551().field_1724).method_23318();
        return Utils.checkRanges(playerY, this.conditions.getYRanges().entries(), this.conditions.getYRanges().excludes());
    }

    protected boolean checkZRanges() {
        double playerZ = Objects.requireNonNull(class_310.method_1551().field_1724).method_23321();
        return Utils.checkRanges(playerZ, this.conditions.getZRanges().entries(), this.conditions.getZRanges().excludes());
    }

    protected boolean checkWeather() {
        class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
        class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
        class_1959.class_1963 precipitation = ((class_1959)world.method_23753(player.method_24515()).comp_349()).method_48162(player.method_24515(), world.method_8615());
        if (this.conditions.getWeathers().entries().isEmpty()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.WORLD_PRECIPITATION) && world.method_8419() && precipitation == class_1959.class_1963.field_9384 && !world.method_8546()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.WORLD_THUNDERSTORM) && world.method_8419() && world.method_8546() && precipitation == class_1959.class_1963.field_9384) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.RAIN_IN_BIOME) && world.method_8419() && precipitation == class_1959.class_1963.field_9382 && !world.method_8546()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.THUNDER_IN_RAIN_BIOME) && world.method_8419() && precipitation == class_1959.class_1963.field_9382 && world.method_8546()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.SNOW_IN_BIOME) && world.method_8419() && precipitation == class_1959.class_1963.field_9383 && !world.method_8546()) {
            return true;
        }
        if (this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.THUNDER_IN_SNOW_BIOME) && world.method_8419() && precipitation == class_1959.class_1963.field_9383 && world.method_8546()) {
            return true;
        }
        return this.conditions.getWeathers().excludes() ^ this.conditions.getWeathers().entries().contains((Object)Weather.NO_PRECIPITATION) && !world.method_8419() && !world.method_8546();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Conditions getConditions() {
        return this.conditions;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int getLayer() {
        return this.properties.layer();
    }

    @Override
    public boolean isActive() {
        return this.getAlpha() != 0.0f;
    }

    public String toString() {
        return String.format("[layer=%s, alpha=%s, dimension=%s, world=%s, biomes=%s, xranges=%s, yranges=%s, zranges=%s, weather=%s, effects=%s]", this.getProperties().layer(), Float.valueOf(this.getAlpha()), this.checkDimensions(), this.checkWorlds(), this.checkBiomes(), this.checkXRanges(), this.checkYRanges(), this.checkZRanges(), this.checkWeather(), this.checkEffects());
    }
}

