/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Function;
import me.flashyreese.mods.nuit.components.Blend;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.components.RGBA;
import me.flashyreese.mods.nuit.mixin.RenderPipelinesAccessor;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.util.Utils;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9958;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL46C;

public class MonoColorSkybox
extends AbstractSkybox {
    private static final Function<BlendFunction, RenderPipeline> MONO_COLOR_SKYBOX_PIPELINE_CONSUMER = blendFunction -> {
        RenderPipeline.Builder builder = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelinesAccessor.getMatricesColorSnippet()});
        builder.withLocation(class_2960.method_43902((String)"nuit", (String)"pipeline/mono_color_skybox"));
        builder.withVertexShader("core/position_color");
        builder.withFragmentShader("core/position_color");
        builder.withDepthWrite(false);
        if (blendFunction != null) {
            builder.withBlend(blendFunction);
        } else {
            builder.withoutBlend();
        }
        builder.withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382);
        return builder.build();
    };
    public static Codec<MonoColorSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.optionalFieldOf("properties", (Object)Properties.of()).forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.of()).forGetter(AbstractSkybox::getConditions), (App)RGBA.CODEC.optionalFieldOf("color", (Object)RGBA.of()).forGetter(MonoColorSkybox::getColor), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.normal()).forGetter(MonoColorSkybox::getBlend)).apply((Applicative)instance, MonoColorSkybox::new));
    public RGBA color;
    public Blend blend;
    private int indexCount = 0;
    private RenderSystem.class_5590 skyIndices;
    private GpuBuffer vertexBuffer = null;

    public MonoColorSkybox(Properties properties, Conditions conditions, RGBA color, Blend blend) {
        super(properties, conditions);
        this.color = color;
        this.blend = blend;
        this.buildSky();
    }

    private void buildSky() {
        VertexFormat vertexFormat = class_290.field_1576;
        VertexFormat.class_5596 vertexFormatMode = VertexFormat.class_5596.field_27382;
        class_9799 byteBufferBuilder = new class_9799(vertexFormat.getVertexSize() * 24);
        class_287 builder = new class_287(byteBufferBuilder, vertexFormatMode, vertexFormat);
        for (int face = 0; face < 6; ++face) {
            Matrix4f matrix4f = Utils.getMatrixForRotatedFace(face);
            builder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22915(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
            builder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22915(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
            builder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22915(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
            builder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22915(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha());
        }
        this.skyIndices = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)vertexFormatMode);
        try (class_9801 meshData = builder.method_60794();){
            if (meshData != null) {
                this.indexCount = meshData.method_60822().comp_751();
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Mono color skybox", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.method_60818());
            }
        }
    }

    @Override
    public void render(SkyRendererAccessor skyRendererAccess, class_4587 poseStack, float tickDelta, class_4184 camera, class_4597.class_4598 bufferSource, class_9958 fogParameters) {
        RenderSystem.setShaderFog((class_9958)fogParameters);
        if (this.alpha > 0.0f && this.vertexBuffer != null) {
            Vector4f colorModifier = this.blend.applyEquationAndGetColor(this.alpha);
            RenderSystem.setShaderColor((float)colorModifier.x, (float)colorModifier.y, (float)colorModifier.z, (float)colorModifier.w);
            RenderPipeline pipeline = MONO_COLOR_SKYBOX_PIPELINE_CONSUMER.apply(this.blend.getBlendFunction());
            class_276 renderTarget = class_310.method_1551().method_1522();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(renderTarget.method_30277(), OptionalInt.empty(), renderTarget.method_30278(), OptionalDouble.empty());){
                renderPass.setPipeline(pipeline);
                renderPass.setVertexBuffer(0, this.vertexBuffer);
                renderPass.setIndexBuffer(this.skyIndices.method_68274(this.indexCount), this.skyIndices.method_31924());
                renderPass.drawIndexed(0, this.indexCount);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL46C.glBlendEquation((int)32774);
        }
    }

    public RGBA getColor() {
        return this.color;
    }

    public Blend getBlend() {
        return this.blend;
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

