/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.flashyreese.mods.nuit.api.skyboxes.Skybox;
import me.flashyreese.mods.nuit.skybox.MonoColorSkybox;
import me.flashyreese.mods.nuit.skybox.decorations.DecorationBox;
import me.flashyreese.mods.nuit.skybox.textured.MultiTexturedSkybox;
import me.flashyreese.mods.nuit.skybox.textured.SquareTexturedSkybox;
import me.flashyreese.mods.nuit.skybox.vanilla.EndSkybox;
import me.flashyreese.mods.nuit.skybox.vanilla.OverworldSkybox;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class SkyboxType<T extends Skybox> {
    public static final Codec<class_2960> SKYBOX_ID_CODEC;
    public static final class_5321<class_2378<SkyboxType<? extends Skybox>>> SKYBOX_TYPE_REGISTRY_KEY;
    public static final SkyboxType<OverworldSkybox> OVERWORLD;
    public static final SkyboxType<EndSkybox> END;
    public static final SkyboxType<MonoColorSkybox> MONO_COLOR_SKYBOX;
    public static final SkyboxType<SquareTexturedSkybox> SQUARE_TEXTURED_SKYBOX;
    public static final SkyboxType<MultiTexturedSkybox> MULTI_TEXTURED_SKYBOX;
    public static final SkyboxType<DecorationBox> DECORATION_BOX;
    private static final Map<class_2960, SkyboxType<?>> SKYBOX_TYPES;
    private final BiMap<Integer, Codec<T>> codecBiMap;
    private final class_2960 name;

    private SkyboxType(String name, int schemaVersion, Codec<T> codec) {
        this(class_2960.method_43902((String)"nuit", (String)name), schemaVersion, codec);
    }

    public SkyboxType(class_2960 name, int schemaVersion, Codec<T> codec) {
        this((BiMap<Integer, Codec<T>>)ImmutableBiMap.builder().put((Object)schemaVersion, codec).build(), name);
    }

    public SkyboxType(BiMap<Integer, Codec<T>> codecBiMap, class_2960 name) {
        this.codecBiMap = codecBiMap;
        this.name = name;
    }

    public static <T extends Skybox> SkyboxType<T> register(SkyboxType<T> type) {
        if (SKYBOX_TYPES.putIfAbsent(type.name, type) != null) {
            throw new IllegalStateException("SkyboxType with name '" + String.valueOf(type.name) + "' already registered!");
        }
        return type;
    }

    public static void registerAll(Consumer<SkyboxType<?>> function) {
        SKYBOX_TYPES.values().forEach(function);
    }

    public class_2960 getName() {
        return this.name;
    }

    public Codec<T> getCodec(int schemaVersion) {
        return Objects.requireNonNull((Codec)this.codecBiMap.get((Object)schemaVersion), String.format("Unsupported schema version '%d' for skybox type %s", schemaVersion, this.name));
    }

    static {
        SKYBOX_TYPE_REGISTRY_KEY = class_5321.method_29180((class_2960)class_2960.method_43902((String)"nuit", (String)"skybox_type"));
        SKYBOX_TYPES = new ConcurrentHashMap();
        SKYBOX_ID_CODEC = Codec.STRING.xmap(s -> {
            if (!s.contains(":")) {
                return class_2960.method_43902((String)"nuit", (String)s);
            }
            return class_2960.method_12829((String)s);
        }, id -> {
            if (id.method_12836().equals("nuit")) {
                return id.method_12832();
            }
            return id.toString();
        });
        OVERWORLD = SkyboxType.register(new SkyboxType<OverworldSkybox>("overworld", 1, OverworldSkybox.CODEC));
        END = SkyboxType.register(new SkyboxType<EndSkybox>("end", 1, EndSkybox.CODEC));
        MONO_COLOR_SKYBOX = SkyboxType.register(new SkyboxType<MonoColorSkybox>("monocolor", 1, MonoColorSkybox.CODEC));
        SQUARE_TEXTURED_SKYBOX = SkyboxType.register(new SkyboxType<SquareTexturedSkybox>("square-textured", 1, SquareTexturedSkybox.CODEC));
        MULTI_TEXTURED_SKYBOX = SkyboxType.register(new SkyboxType<MultiTexturedSkybox>("multi-textured", 1, MultiTexturedSkybox.CODEC));
        DECORATION_BOX = SkyboxType.register(new SkyboxType<DecorationBox>("decorations", 1, DecorationBox.CODEC));
    }
}

