/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox.decorations;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import me.flashyreese.mods.nuit.components.Blend;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.util.OverrideUtils;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import net.minecraft.class_9958;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL46C;

public class DecorationBox
extends AbstractSkybox {
    public static Codec<DecorationBox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.optionalFieldOf("properties", (Object)Properties.decorations()).forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.of()).forGetter(AbstractSkybox::getConditions), (App)class_2960.field_25139.optionalFieldOf("sun", (Object)SkyRendererAccessor.getSun()).forGetter(DecorationBox::getSunTexture), (App)class_2960.field_25139.optionalFieldOf("moon", (Object)SkyRendererAccessor.getMoonPhases()).forGetter(DecorationBox::getMoonTexture), (App)Codec.BOOL.optionalFieldOf("showSun", (Object)false).forGetter(DecorationBox::isSunEnabled), (App)Codec.BOOL.optionalFieldOf("showMoon", (Object)false).forGetter(DecorationBox::isMoonEnabled), (App)Codec.BOOL.optionalFieldOf("showStars", (Object)false).forGetter(DecorationBox::isStarsEnabled), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.decorations()).forGetter(DecorationBox::getBlend)).apply((Applicative)instance, DecorationBox::new));
    private final class_2960 sunTexture;
    private final class_2960 moonTexture;
    private final boolean sunEnabled;
    private final boolean moonEnabled;
    private final boolean starsEnabled;
    private final Blend blend;

    public DecorationBox(Properties properties, Conditions conditions, class_2960 sun, class_2960 moon, boolean sunEnabled, boolean moonEnabled, boolean starsEnabled, Blend blend) {
        this.properties = properties;
        this.conditions = conditions;
        this.sunTexture = sun;
        this.moonTexture = moon;
        this.sunEnabled = sunEnabled;
        this.moonEnabled = moonEnabled;
        this.starsEnabled = starsEnabled;
        this.blend = blend;
    }

    @Override
    public void render(SkyRendererAccessor skyRendererAccessor, class_4587 poseStack, float tickDelta, class_4184 camera, class_4597.class_4598 bufferSource, class_9958 fogParameters) {
        RenderSystem.setShaderFog((class_9958)fogParameters);
        class_638 level = Objects.requireNonNull((class_638)camera.method_19331().method_37908());
        OverrideUtils.enableBlendingOverride(this.blend.getBlendFunction());
        Vector4f colorModifier = this.blend.applyEquationAndGetColor(this.alpha);
        RenderSystem.setShaderColor((float)colorModifier.x, (float)colorModifier.y, (float)colorModifier.z, (float)colorModifier.w);
        poseStack.method_22903();
        this.properties.rotation().apply(poseStack, level);
        if (this.sunEnabled) {
            this.renderSun((class_4597)bufferSource, poseStack);
        }
        if (this.moonEnabled) {
            this.renderMoon(level.method_30273(), (class_4597)bufferSource, poseStack);
        }
        if (this.sunEnabled || this.moonEnabled) {
            bufferSource.method_22993();
        }
        if (this.starsEnabled) {
            skyRendererAccessor.invokeRenderStars(fogParameters, level.method_23787(tickDelta), poseStack);
        }
        poseStack.method_22909();
        OverrideUtils.disableBlendingOverride();
        GL46C.glBlendEquation((int)32774);
    }

    public void renderSun(class_4597 multiBufferSource, class_4587 poseStack) {
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_65215((class_2960)this.sunTexture));
        int i = class_9848.method_61317((float)1.0f);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        vertexConsumer.method_22918(matrix4f, -30.0f, 100.0f, -30.0f).method_22913(0.0f, 0.0f).method_39415(i);
        vertexConsumer.method_22918(matrix4f, 30.0f, 100.0f, -30.0f).method_22913(1.0f, 0.0f).method_39415(i);
        vertexConsumer.method_22918(matrix4f, 30.0f, 100.0f, 30.0f).method_22913(1.0f, 1.0f).method_39415(i);
        vertexConsumer.method_22918(matrix4f, -30.0f, 100.0f, 30.0f).method_22913(0.0f, 1.0f).method_39415(i);
    }

    public void renderMoon(int moonPhase, class_4597 multiBufferSource, class_4587 poseStack) {
        int xCoord = moonPhase % 4;
        int yCoord = moonPhase / 4 % 2;
        float startX = (float)xCoord / 4.0f;
        float startY = (float)yCoord / 2.0f;
        float endX = (float)(xCoord + 1) / 4.0f;
        float endY = (float)(yCoord + 1) / 2.0f;
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_65215((class_2960)this.moonTexture));
        int p = class_9848.method_61317((float)1.0f);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        vertexConsumer.method_22918(matrix4f, -20.0f, -100.0f, 20.0f).method_22913(endX, endY).method_39415(p);
        vertexConsumer.method_22918(matrix4f, 20.0f, -100.0f, 20.0f).method_22913(startX, endY).method_39415(p);
        vertexConsumer.method_22918(matrix4f, 20.0f, -100.0f, -20.0f).method_22913(startX, startY).method_39415(p);
        vertexConsumer.method_22918(matrix4f, -20.0f, -100.0f, -20.0f).method_22913(endX, startY).method_39415(p);
    }

    public class_2960 getSunTexture() {
        return this.sunTexture;
    }

    public class_2960 getMoonTexture() {
        return this.moonTexture;
    }

    public boolean isSunEnabled() {
        return this.sunEnabled;
    }

    public boolean isMoonEnabled() {
        return this.moonEnabled;
    }

    public boolean isStarsEnabled() {
        return this.starsEnabled;
    }

    public Blend getBlend() {
        return this.blend;
    }

    @Override
    public void close() {
    }
}

