/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox.textured;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import me.flashyreese.mods.nuit.components.AnimatableTexture;
import me.flashyreese.mods.nuit.components.Blend;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.components.UVRange;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.skybox.textured.TexturedSkybox;
import me.flashyreese.mods.nuit.util.Utils;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9958;
import org.joml.Matrix4f;

public class MultiTexturedSkybox
extends TexturedSkybox {
    public static Codec<MultiTexturedSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.optionalFieldOf("properties", (Object)Properties.of()).forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.of()).forGetter(AbstractSkybox::getConditions), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.normal()).forGetter(TexturedSkybox::getBlend), (App)AnimatableTexture.CODEC.listOf().optionalFieldOf("animatableTextures", new ArrayList()).forGetter(MultiTexturedSkybox::getAnimations)).apply((Applicative)instance, MultiTexturedSkybox::new));
    protected final List<AnimatableTexture> animatableTextures;
    private final float quadSize = 100.0f;
    private final UVRange quad = new UVRange(-this.quadSize, -this.quadSize, this.quadSize, this.quadSize);

    public MultiTexturedSkybox(Properties properties, Conditions conditions, Blend blend, List<AnimatableTexture> animatableTextures) {
        super(properties, conditions, blend);
        this.animatableTextures = animatableTextures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderSkybox(SkyRendererAccessor skyRendererAccess, class_4587 poseStack, float tickDelta, class_4184 camera, class_4597.class_4598 bufferSource, class_9958 fogParameters) {
        RenderSystem.setShaderFog((class_9958)fogParameters);
        for (int face = 0; face < 6; ++face) {
            Matrix4f matrix4f = Utils.getMatrixForRotatedFace(face);
            UVRange faceUVRange = Utils.TEXTURE_FACES[face];
            for (AnimatableTexture animatableTexture : this.animatableTextures) {
                animatableTexture.tick();
                UVRange intersect = Utils.findUVIntersection(faceUVRange, animatableTexture.getUvRange());
                if (intersect == null || animatableTexture.getCurrentFrame() == null) continue;
                UVRange intersectionOnCurrentTexture = Utils.mapUVRanges(faceUVRange, this.quad, intersect);
                UVRange intersectionOnCurrentFrame = Utils.mapUVRanges(animatableTexture.getUvRange(), animatableTexture.getCurrentFrame(), intersect);
                VertexFormat vertexFormat = class_290.field_1585;
                VertexFormat.class_5596 vertexFormatMode = VertexFormat.class_5596.field_27382;
                class_9799 byteBufferBuilder = new class_9799(vertexFormat.getVertexSize() * 4);
                class_287 builder = new class_287(byteBufferBuilder, vertexFormatMode, vertexFormat);
                builder.method_22918(matrix4f, intersectionOnCurrentTexture.minU(), -this.quadSize, intersectionOnCurrentTexture.minV()).method_22913(intersectionOnCurrentFrame.minU(), intersectionOnCurrentFrame.minV());
                builder.method_22918(matrix4f, intersectionOnCurrentTexture.minU(), -this.quadSize, intersectionOnCurrentTexture.maxV()).method_22913(intersectionOnCurrentFrame.minU(), intersectionOnCurrentFrame.maxV());
                builder.method_22918(matrix4f, intersectionOnCurrentTexture.maxU(), -this.quadSize, intersectionOnCurrentTexture.maxV()).method_22913(intersectionOnCurrentFrame.maxU(), intersectionOnCurrentFrame.maxV());
                builder.method_22918(matrix4f, intersectionOnCurrentTexture.maxU(), -this.quadSize, intersectionOnCurrentTexture.minV()).method_22913(intersectionOnCurrentFrame.maxU(), intersectionOnCurrentFrame.minV());
                int indexCount = 0;
                GpuBuffer vertexBuffer = null;
                class_9801 meshData = builder.method_60794();
                if (meshData != null) {
                    indexCount = meshData.method_60822().comp_751();
                    vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Multi textured skybox", BufferType.VERTICES, BufferUsage.DYNAMIC_WRITE, meshData.method_60818());
                }
                if (vertexBuffer == null) continue;
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)vertexFormatMode);
                GpuTexture texture = class_310.method_1551().method_1531().method_4619(animatableTexture.getTexture().getTextureId()).method_68004();
                RenderPipeline pipeline = (RenderPipeline)TEXTURED_SKYBOX_PIPELINE_CONSUMER.apply(this.getBlend().getBlendFunction());
                class_276 renderTarget = class_310.method_1551().method_1522();
                try {
                    RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(renderTarget.method_30277(), OptionalInt.empty(), renderTarget.method_30278(), OptionalDouble.empty());
                    try {
                        renderPass.setPipeline(pipeline);
                        renderPass.setVertexBuffer(0, vertexBuffer);
                        renderPass.setIndexBuffer(autoStorageIndexBuffer.method_68274(indexCount), autoStorageIndexBuffer.method_31924());
                        renderPass.bindSampler("Sampler0", texture);
                        renderPass.drawIndexed(0, indexCount);
                    }
                    finally {
                        if (renderPass == null) continue;
                        renderPass.close();
                    }
                }
                finally {
                    vertexBuffer.close();
                    meshData.close();
                }
            }
        }
    }

    public List<AnimatableTexture> getAnimations() {
        return this.animatableTextures;
    }

    @Override
    public List<class_2960> getTexturesToRegister() {
        return this.animatableTextures.stream().map(texture -> texture.getTexture().getTextureId()).toList();
    }

    @Override
    public void close() {
    }
}

