/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox.textured;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import me.flashyreese.mods.nuit.components.Blend;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.components.Texture;
import me.flashyreese.mods.nuit.components.UVRange;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.skybox.textured.TexturedSkybox;
import me.flashyreese.mods.nuit.util.Utils;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9958;
import org.joml.Matrix4f;

public class SquareTexturedSkybox
extends TexturedSkybox {
    public static Codec<SquareTexturedSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.optionalFieldOf("properties", (Object)Properties.of()).forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.of()).forGetter(AbstractSkybox::getConditions), (App)Blend.CODEC.optionalFieldOf("blend", (Object)Blend.normal()).forGetter(TexturedSkybox::getBlend), (App)Texture.CODEC.fieldOf("texture").forGetter(SquareTexturedSkybox::getTexture)).apply((Applicative)instance, SquareTexturedSkybox::new));
    protected Texture texture;
    private int indexCount = 0;
    private RenderSystem.class_5590 skyIndices;
    private GpuBuffer vertexBuffer = null;

    public SquareTexturedSkybox(Properties properties, Conditions conditions, Blend blend, Texture texture) {
        super(properties, conditions, blend);
        this.texture = texture;
        this.buildSky();
    }

    private void buildSky() {
        VertexFormat vertexFormat = class_290.field_1585;
        VertexFormat.class_5596 vertexFormatMode = VertexFormat.class_5596.field_27382;
        class_9799 byteBufferBuilder = new class_9799(vertexFormat.getVertexSize() * 24);
        class_287 builder = new class_287(byteBufferBuilder, vertexFormatMode, vertexFormat);
        for (int face = 0; face < 6; ++face) {
            UVRange tex = Utils.TEXTURE_FACES[face];
            Matrix4f matrix4f = Utils.getMatrixForRotatedFace(face);
            builder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(tex.minU(), tex.minV());
            builder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(tex.minU(), tex.maxV());
            builder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(tex.maxU(), tex.maxV());
            builder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(tex.maxU(), tex.minV());
        }
        this.skyIndices = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)vertexFormatMode);
        try (class_9801 meshData = builder.method_60794();){
            if (meshData != null) {
                this.indexCount = meshData.method_60822().comp_751();
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Square textured skybox", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.method_60818());
            }
        }
    }

    @Override
    public void renderSkybox(SkyRendererAccessor skyRendererAccess, class_4587 poseStack, float tickDelta, class_4184 camera, class_4597.class_4598 bufferSource, class_9958 fogParameters) {
        RenderSystem.setShaderFog((class_9958)fogParameters);
        if (this.vertexBuffer != null) {
            GpuTexture texture = class_310.method_1551().method_1531().method_4619(this.texture.getTextureId()).method_68004();
            RenderPipeline pipeline = (RenderPipeline)TEXTURED_SKYBOX_PIPELINE_CONSUMER.apply(this.getBlend().getBlendFunction());
            class_276 renderTarget = class_310.method_1551().method_1522();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(renderTarget.method_30277(), OptionalInt.empty(), renderTarget.method_30278(), OptionalDouble.empty());){
                renderPass.setPipeline(pipeline);
                renderPass.setVertexBuffer(0, this.vertexBuffer);
                renderPass.setIndexBuffer(this.skyIndices.method_68274(this.indexCount), this.skyIndices.method_31924());
                renderPass.bindSampler("Sampler0", texture);
                renderPass.drawIndexed(0, this.indexCount);
            }
        }
    }

    @Override
    public List<class_2960> getTexturesToRegister() {
        return List.of(this.texture.getTextureId());
    }

    public Texture getTexture() {
        return this.texture;
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

