/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox.textured;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.function.Function;
import me.flashyreese.mods.nuit.components.Blend;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.components.Rotation;
import me.flashyreese.mods.nuit.mixin.RenderPipelinesAccessor;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.skybox.TextureRegistrar;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_9958;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL46C;

public abstract class TexturedSkybox
extends AbstractSkybox
implements TextureRegistrar {
    public static final Function<BlendFunction, RenderPipeline> TEXTURED_SKYBOX_PIPELINE_CONSUMER = blendFunction -> {
        RenderPipeline.Builder builder = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelinesAccessor.getMatricesColorSnippet()});
        builder.withLocation(class_2960.method_43902((String)"nuit", (String)"pipeline/textured_skybox"));
        builder.withVertexShader("core/position_tex");
        builder.withFragmentShader("core/position_tex");
        builder.withDepthWrite(false);
        if (blendFunction != null) {
            builder.withBlend(blendFunction);
        } else {
            builder.withoutBlend();
        }
        builder.withSampler("Sampler0");
        builder.withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382);
        return builder.build();
    };
    private final Rotation rotation;
    private final Blend blend;

    protected TexturedSkybox(Properties properties, Conditions conditions, Blend blend) {
        super(properties, conditions);
        this.blend = blend;
        this.rotation = properties.rotation();
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Blend getBlend() {
        return this.blend;
    }

    @Override
    public final void render(SkyRendererAccessor skyRendererAccess, class_4587 poseStack, float tickDelta, class_4184 camera, class_4597.class_4598 bufferSource, class_9958 fogParameters) {
        Vector4f colorModifier = this.blend.applyEquationAndGetColor(this.alpha);
        RenderSystem.setShaderColor((float)colorModifier.x, (float)colorModifier.y, (float)colorModifier.z, (float)colorModifier.w);
        class_638 level = Objects.requireNonNull(class_310.method_1551().field_1687);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        this.rotation.apply((Matrix4f)modelViewStack, level);
        this.renderSkybox(skyRendererAccess, poseStack, tickDelta, camera, bufferSource, fogParameters);
        modelViewStack.popMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL46C.glBlendEquation((int)32774);
    }

    public abstract void renderSkybox(SkyRendererAccessor var1, class_4587 var2, float var3, class_4184 var4, class_4597.class_4598 var5, class_9958 var6);
}

