/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox.vanilla;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.util.Utils;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import net.minecraft.class_9851;
import net.minecraft.class_9958;
import net.minecraft.class_9975;
import org.joml.Matrix4f;

public class EndSkybox
extends AbstractSkybox {
    public static Codec<EndSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.optionalFieldOf("properties", (Object)Properties.of()).forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.of()).forGetter(AbstractSkybox::getConditions)).apply((Applicative)instance, EndSkybox::new));
    private int indexCount = 0;
    private RenderSystem.class_5590 skyIndices;
    private GpuBuffer vertexBuffer = null;

    public EndSkybox(Properties properties, Conditions conditions) {
        super(properties, conditions);
        this.buildSky();
    }

    private void buildSky() {
        VertexFormat vertexFormat = class_290.field_1575;
        VertexFormat.class_5596 vertexFormatMode = VertexFormat.class_5596.field_27382;
        class_9799 byteBufferBuilder = new class_9799(vertexFormat.getVertexSize() * 24);
        class_287 builder = new class_287(byteBufferBuilder, vertexFormatMode, vertexFormat);
        for (int face = 0; face < 6; ++face) {
            int color = class_9848.method_61330((int)0x282828, (int)((int)(255.0f * this.alpha)));
            Matrix4f matrix4f = Utils.getMatrixForRotatedFace(face);
            builder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_39415(color);
            builder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_39415(color);
            builder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_39415(color);
            builder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_39415(color);
        }
        this.skyIndices = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)vertexFormatMode);
        try (class_9801 meshData = builder.method_60794();){
            if (meshData != null) {
                this.indexCount = meshData.method_60822().comp_751();
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "End skybox", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.method_60818());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(SkyRendererAccessor skyRendererAccess, class_4587 poseStack, float tickDelta, class_4184 camera, class_4597.class_4598 bufferSource, class_9958 fogParameters) {
        if (this.vertexBuffer != null) {
            class_1060 textureManager = class_310.method_1551().method_1531();
            class_1044 abstractTexture = textureManager.method_4619(class_9975.field_53143);
            abstractTexture.method_65923(class_9851.field_52395, false);
            class_276 renderTarget = class_310.method_1551().method_1522();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(renderTarget.method_30277(), OptionalInt.empty(), renderTarget.method_30278(), OptionalDouble.empty());){
                renderPass.setPipeline(class_10799.field_56875);
                renderPass.setVertexBuffer(0, null);
                renderPass.setIndexBuffer(this.skyIndices.method_68274(this.indexCount), this.skyIndices.method_31924());
                renderPass.bindSampler("Sampler0", abstractTexture.method_68004());
                renderPass.drawIndexed(0, this.indexCount);
            }
            finally {
                this.vertexBuffer.close();
            }
        }
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

