/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.skybox.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.flashyreese.mods.nuit.api.NuitApi;
import me.flashyreese.mods.nuit.components.Conditions;
import me.flashyreese.mods.nuit.components.Properties;
import me.flashyreese.mods.nuit.mixin.SkyRendererAccessor;
import me.flashyreese.mods.nuit.skybox.AbstractSkybox;
import me.flashyreese.mods.nuit.skybox.decorations.DecorationBox;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5539;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_9848;
import net.minecraft.class_9958;
import net.minecraft.class_9975;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class OverworldSkybox
extends AbstractSkybox {
    public static Codec<OverworldSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.optionalFieldOf("properties", (Object)Properties.of()).forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.of()).forGetter(AbstractSkybox::getConditions)).apply((Applicative)instance, OverworldSkybox::new));

    public OverworldSkybox(Properties properties, Conditions conditions) {
        super(properties, conditions);
    }

    @Override
    public void render(SkyRendererAccessor skyRendererAccessor, class_4587 poseStack, float tickDelta, class_4184 camera, class_4597.class_4598 bufferSource, class_9958 fogParameters) {
        double eyeHeight;
        RenderSystem.setShaderFog((class_9958)fogParameters);
        class_638 level = (class_638)camera.method_19331().method_37908();
        float sunAngle = level.method_8442(tickDelta);
        float timeOfDay = level.method_30274(tickDelta);
        int sunriseOrSunsetColor = level.method_28103().method_62184(timeOfDay);
        int skyColor = level.method_23777(camera.method_19326(), tickDelta);
        ((class_9975)skyRendererAccessor).method_62302(class_9848.method_65101((int)skyColor), class_9848.method_65102((int)skyColor), class_9848.method_65103((int)skyColor));
        if (level.method_28103().method_62183(timeOfDay)) {
            if (NuitApi.getInstance().getActiveSkyboxes().stream().anyMatch(skybox -> {
                DecorationBox decorationBox;
                return skybox instanceof DecorationBox && (decorationBox = (DecorationBox)skybox).getProperties().rotation().skyboxRotation();
            })) {
                sunAngle = class_3532.method_15341((float)((float)level.method_8532() / 24000.0f + 0.75f), (float)1.0f);
            }
            this.renderSunriseAndSunset(poseStack, bufferSource, sunAngle, sunriseOrSunsetColor);
        }
        if ((eyeHeight = camera.method_19331().method_5836((float)tickDelta).field_1351 - level.method_28104().method_28105((class_5539)level)) < 0.0) {
            ((class_9975)skyRendererAccessor).method_62305();
        }
    }

    private void renderSunriseAndSunset(class_4587 poseStack, class_4597.class_4598 bufferSource, float sunAngle, int sunriseOrSunsetColor) {
        poseStack.method_22903();
        poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
        float zRotation = class_3532.method_15374((float)sunAngle) < 0.0f ? 180.0f : 0.0f;
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(zRotation));
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(90.0f));
        Matrix4f transformationMatrix = poseStack.method_23760().method_23761();
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_65220());
        float alpha = class_9848.method_65100((int)sunriseOrSunsetColor) * this.alpha;
        vertexConsumer.method_22918(transformationMatrix, 0.0f, 100.0f, 0.0f).method_39415(sunriseOrSunsetColor);
        int transparentColor = class_9848.method_61335((int)sunriseOrSunsetColor);
        for (int i = 0; i <= 16; ++i) {
            float angleRadians = (float)i * ((float)Math.PI * 2) / 16.0f;
            float x = class_3532.method_15374((float)angleRadians);
            float y = class_3532.method_15362((float)angleRadians);
            float z = -y * 40.0f * alpha;
            vertexConsumer.method_22918(transformationMatrix, x * 120.0f, y * 120.0f, z).method_39415(transparentColor);
        }
        bufferSource.method_22993();
        poseStack.method_22909();
    }

    @Override
    public void close() {
    }
}

