/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.util;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_3532;

public class CodecUtils {
    public static Codec<Long> getClampedLong(long min, long max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.LONG.xmap(f -> class_3532.method_53062((long)f, (long)min, (long)max), Function.identity());
    }

    public static Codec<Integer> getClampedInteger(int min, int max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.INT.xmap(f -> class_3532.method_15340((int)f, (int)min, (int)max), Function.identity());
    }

    public static Codec<Float> getClampedFloat(float min, float max) {
        if (min > max) {
            throw new UnsupportedOperationException("Maximum value was lesser than than the minimum value");
        }
        return Codec.FLOAT.xmap(f -> Float.valueOf(class_3532.method_15363((float)f.floatValue(), (float)min, (float)max)), Function.identity());
    }

    public static <K extends Number, V> Codec<Map<K, V>> unboundedMapFixed(Class<K> clazz, Codec<V> valueCodec, Supplier<Map<K, V>> mapSupplier) {
        return Codec.unboundedMap((Codec)Codec.STRING, valueCodec).xmap(map -> (Map)map.entrySet().stream().collect(Collectors.toMap(entry -> {
            String key = (String)entry.getKey();
            if (clazz == Integer.class) {
                return (Number)clazz.cast(Integer.parseInt(key));
            }
            if (clazz == Long.class) {
                return (Number)clazz.cast(Long.parseLong(key));
            }
            if (clazz == Double.class) {
                return (Number)clazz.cast(Double.parseDouble(key));
            }
            if (clazz == Float.class) {
                return (Number)clazz.cast(Float.valueOf(Float.parseFloat(key)));
            }
            if (clazz == Short.class) {
                return (Number)clazz.cast(Short.parseShort(key));
            }
            if (clazz == Byte.class) {
                return (Number)clazz.cast(Byte.parseByte(key));
            }
            throw new IllegalArgumentException("Unsupported number class: " + String.valueOf(clazz));
        }, Map.Entry::getValue, (a, b) -> a, mapSupplier)), map -> map.entrySet().stream().collect(Collectors.toMap(entry -> ((Number)entry.getKey()).toString(), Map.Entry::getValue)));
    }

    public static Map<Integer, Long> fastUtilInt2LongArrayMap() {
        return new Int2LongArrayMap();
    }

    public static Map<Long, Float> fastUtilLong2FloatOpenHashMap() {
        return new Long2FloatOpenHashMap();
    }

    public static <T> Map<Long, T> fastUtilLong2ObjectOpenHashMap() {
        return new Long2ObjectOpenHashMap();
    }
}

