/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.nuit.util;

import com.google.common.collect.Range;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import me.flashyreese.mods.nuit.NuitClient;
import me.flashyreese.mods.nuit.api.skyboxes.NuitSkybox;
import me.flashyreese.mods.nuit.api.skyboxes.Skybox;
import me.flashyreese.mods.nuit.components.Fog;
import me.flashyreese.mods.nuit.components.RGB;
import me.flashyreese.mods.nuit.components.RangeEntry;
import me.flashyreese.mods.nuit.components.UVRange;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class Utils {
    public static final UVRange[] TEXTURE_FACES = new UVRange[]{new UVRange(0.0f, 0.0f, 0.33333334f, 0.5f), new UVRange(0.33333334f, 0.5f, 0.6666667f, 1.0f), new UVRange(0.6666667f, 0.0f, 1.0f, 0.5f), new UVRange(0.33333334f, 0.0f, 0.6666667f, 0.5f), new UVRange(0.6666667f, 0.5f, 1.0f, 1.0f), new UVRange(0.0f, 0.5f, 0.33333334f, 1.0f)};
    private static final Matrix4f[] MATRIX4F_ROTATED_FACE = new Matrix4f[]{new Matrix4f(), new Matrix4f().rotateX((float)Math.toRadians(90.0)), new Matrix4f().rotateX((float)Math.toRadians(-90.0)).rotateY((float)Math.toRadians(180.0)), new Matrix4f().rotateX((float)Math.toRadians(180.0)), new Matrix4f().rotateZ((float)Math.toRadians(90.0)).rotateY((float)Math.toRadians(-90.0)), new Matrix4f().rotateZ((float)Math.toRadians(-90.0)).rotateY((float)Math.toRadians(90.0))};

    public static UVRange mapUVRanges(UVRange input, UVRange output, UVRange inputIntersection) {
        float inputUWidth = input.maxU() - input.minU();
        float outputUWidth = output.maxU() - output.minU();
        float inputVHeight = input.maxV() - input.minV();
        float outputVHeight = output.maxV() - output.minV();
        float u1 = (inputIntersection.minU() - input.minU()) / inputUWidth * outputUWidth + output.minU();
        float u2 = (inputIntersection.maxU() - input.minU()) / inputUWidth * outputUWidth + output.minU();
        float v1 = (inputIntersection.minV() - input.minV()) / inputVHeight * outputVHeight + output.minV();
        float v2 = (inputIntersection.maxV() - input.minV()) / inputVHeight * outputVHeight + output.minV();
        return new UVRange(u1, v1, u2, v2);
    }

    public static UVRange findUVIntersection(UVRange first, UVRange second) {
        float intersectionMinU = Math.max(first.minU(), second.minU());
        float intersectionMaxU = Math.min(first.maxU(), second.maxU());
        float intersectionMinV = Math.max(first.minV(), second.minV());
        float intersectionMaxV = Math.min(first.maxV(), second.maxV());
        if (intersectionMaxU >= intersectionMinU && intersectionMaxV >= intersectionMinV) {
            return new UVRange(intersectionMinU, intersectionMinV, intersectionMaxU, intersectionMaxV);
        }
        return null;
    }

    public static boolean checkRanges(double value, List<RangeEntry> rangeEntries, boolean inverse) {
        return rangeEntries.isEmpty() || inverse ^ rangeEntries.stream().map(entry -> Range.closedOpen((Comparable)Float.valueOf(entry.min()), (Comparable)Float.valueOf(entry.max()))).anyMatch(range -> range.contains((Comparable)Float.valueOf((float)value)));
    }

    public static double calculateRotation(double rotationSpeed, boolean isSkyboxRotation, class_638 world) {
        if (rotationSpeed != 0.0) {
            long timeOfDay = world.method_8532();
            double rotationFraction = (double)timeOfDay / (24000.0 / rotationSpeed);
            double skyAngle = class_3532.method_15367((double)rotationFraction, (double)1.0);
            if (isSkyboxRotation) {
                return 360.0 * skyAngle;
            }
            return 360.0 * (double)world.method_8597().method_28528((long)(24000.0 * skyAngle));
        }
        return 0.0;
    }

    public static Matrix4f getMatrixForRotatedFace(int face) {
        if (face >= MATRIX4F_ROTATED_FACE.length) {
            throw new RuntimeException("Face is out of bounds");
        }
        return MATRIX4F_ROTATED_FACE[face];
    }

    public static void rotateSkyBoxByFace(class_4587 poseStack, int face) {
        if (face == 1) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
        } else if (face == 2) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        } else if (face == 3) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f));
        } else if (face == 4) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(90.0f));
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        } else if (face == 5) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(-90.0f));
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        }
    }

    public static float calculateInterpolatedAlpha(long currentTime, long duration, long currentKeyFrame, long nextKeyFrame, float currentKeyFrameValue, float nextKeyFrameValue) {
        long timePassedInCycle;
        long cycleDuration;
        if (currentKeyFrameValue == nextKeyFrameValue || currentKeyFrame == nextKeyFrame) {
            return nextKeyFrameValue;
        }
        if (currentKeyFrame > nextKeyFrame) {
            cycleDuration = duration - currentKeyFrame + nextKeyFrame;
            timePassedInCycle = currentTime < nextKeyFrame ? duration - currentKeyFrame + currentTime : currentTime - currentKeyFrame;
        } else {
            cycleDuration = nextKeyFrame - currentKeyFrame;
            timePassedInCycle = currentTime - currentKeyFrame;
        }
        return currentKeyFrameValue + (float)timePassedInCycle / (float)cycleDuration * (nextKeyFrameValue - currentKeyFrameValue);
    }

    public static <T> Optional<class_3545<Long, Long>> findClosestKeyframes(Map<Long, T> keyFrames, long currentTime) {
        if (keyFrames.isEmpty()) {
            return Optional.empty();
        }
        long smallestValue = Long.MAX_VALUE;
        long largestValue = Long.MIN_VALUE;
        long closestLowerKeyFrame = Long.MIN_VALUE;
        long closestHigherKeyFrame = Long.MAX_VALUE;
        for (long keyFrame : keyFrames.keySet()) {
            if (keyFrame < smallestValue) {
                smallestValue = keyFrame;
            }
            if (keyFrame > largestValue) {
                largestValue = keyFrame;
            }
            if (keyFrame <= currentTime && keyFrame > closestLowerKeyFrame) {
                closestLowerKeyFrame = keyFrame;
            }
            if (keyFrame <= currentTime || keyFrame >= closestHigherKeyFrame) continue;
            closestHigherKeyFrame = keyFrame;
        }
        if (closestLowerKeyFrame == Long.MIN_VALUE || closestHigherKeyFrame == Long.MAX_VALUE) {
            closestLowerKeyFrame = largestValue;
            closestHigherKeyFrame = smallestValue;
        }
        return Optional.of(new class_3545((Object)closestLowerKeyFrame, (Object)closestHigherKeyFrame));
    }

    public static Quaternionf interpolateQuatKeyframes(Map<Long, Quaternionf> keyFrames, class_3545<Long, Long> chosenFrames, long currentTime, long duration) {
        long timePassedInCycle;
        long cycleDuration;
        long nextKey;
        if (keyFrames.size() == 1) {
            return keyFrames.values().iterator().next();
        }
        long currentKey = (Long)chosenFrames.method_15442();
        if (currentKey > (nextKey = ((Long)chosenFrames.method_15441()).longValue())) {
            cycleDuration = duration - currentKey + nextKey;
            timePassedInCycle = currentTime < nextKey ? duration - currentKey + currentTime : currentTime - currentKey;
        } else {
            cycleDuration = nextKey - currentKey;
            timePassedInCycle = currentTime - currentKey;
        }
        float alpha = (float)timePassedInCycle / (float)cycleDuration;
        Quaternionf result = new Quaternionf();
        keyFrames.get(currentKey).nlerp((Quaternionfc)keyFrames.get(nextKey), alpha, result);
        return result;
    }

    public static RGB alphaBlendFogColors(List<Skybox> skyboxList, RGB initialFogColor) {
        RGB destination = initialFogColor;
        for (Skybox skybox : skyboxList) {
            NuitSkybox nuitSkybox;
            if (!skybox.isActive() || !(skybox instanceof NuitSkybox) || !(nuitSkybox = (NuitSkybox)skybox).getProperties().fog().isModifyColors()) continue;
            Fog fogColor = nuitSkybox.getProperties().fog();
            destination = fogColor.blend(destination, nuitSkybox.getAlpha());
        }
        return destination;
    }

    public static float alphaBlendFogDensity(List<Skybox> skyboxList, float initialFogDensity) {
        float destination = initialFogDensity;
        for (Skybox skybox : skyboxList) {
            NuitSkybox nuitSkybox;
            if (!skybox.isActive() || !(skybox instanceof NuitSkybox) || !(nuitSkybox = (NuitSkybox)skybox).getProperties().fog().isModifyDensity()) continue;
            float sourceAlphaInv = 1.0f - nuitSkybox.getAlpha();
            destination = nuitSkybox.getProperties().fog().getDensity() * nuitSkybox.getAlpha() + destination * sourceAlphaInv;
        }
        return destination;
    }

    public static float calculateConditionAlphaValue(float maxAlpha, float minAlpha, float lastAlpha, int duration, boolean in) {
        if (duration == 0) {
            return lastAlpha;
        }
        if (in && maxAlpha == lastAlpha) {
            return maxAlpha;
        }
        if (!in && lastAlpha == minAlpha) {
            return minAlpha;
        }
        float alphaChange = (maxAlpha - minAlpha) / (float)duration;
        float result = in ? lastAlpha + alphaChange : lastAlpha - alphaChange;
        return class_3532.method_15363((float)result, (float)minAlpha, (float)maxAlpha);
    }

    public static <T> T loadService(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        NuitClient.getLogger().debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static SourceFactor toSourceFactor(int glId) {
        return switch (glId) {
            case 32771 -> SourceFactor.CONSTANT_ALPHA;
            case 32769 -> SourceFactor.CONSTANT_COLOR;
            case 772 -> SourceFactor.DST_ALPHA;
            case 774 -> SourceFactor.DST_COLOR;
            case 1 -> SourceFactor.ONE;
            case 32772 -> SourceFactor.ONE_MINUS_CONSTANT_ALPHA;
            case 32770 -> SourceFactor.ONE_MINUS_CONSTANT_COLOR;
            case 773 -> SourceFactor.ONE_MINUS_DST_ALPHA;
            case 775 -> SourceFactor.ONE_MINUS_DST_COLOR;
            case 771 -> SourceFactor.ONE_MINUS_SRC_ALPHA;
            case 769 -> SourceFactor.ONE_MINUS_SRC_COLOR;
            case 770 -> SourceFactor.SRC_ALPHA;
            case 768 -> SourceFactor.SRC_COLOR;
            case 0 -> SourceFactor.ZERO;
            default -> throw new RuntimeException("Unknown SourceFactor with GL id of " + glId);
        };
    }

    public static DestFactor toDestFactor(int glId) {
        return switch (glId) {
            case 32771 -> DestFactor.CONSTANT_ALPHA;
            case 32769 -> DestFactor.CONSTANT_COLOR;
            case 772 -> DestFactor.DST_ALPHA;
            case 774 -> DestFactor.DST_COLOR;
            case 1 -> DestFactor.ONE;
            case 32772 -> DestFactor.ONE_MINUS_CONSTANT_ALPHA;
            case 32770 -> DestFactor.ONE_MINUS_CONSTANT_COLOR;
            case 773 -> DestFactor.ONE_MINUS_DST_ALPHA;
            case 775 -> DestFactor.ONE_MINUS_DST_COLOR;
            case 771 -> DestFactor.ONE_MINUS_SRC_ALPHA;
            case 769 -> DestFactor.ONE_MINUS_SRC_COLOR;
            case 770 -> DestFactor.SRC_ALPHA;
            case 768 -> DestFactor.SRC_COLOR;
            case 0 -> DestFactor.ZERO;
            default -> throw new RuntimeException("Unknown DestFactor with GL id of " + glId);
        };
    }
}

