#version 150

in vec4 vertexColor;

flat in vec2 flatCorner;
in vec2 Pos1;
in vec2 Pos2;
in vec4 Coords;
in vec2 position;

uniform vec4 ColorModulator;

out vec4 fragColor;

vec4 colors[4] = vec4[](
    vec4(0),
    vec4(20, 17, 25, 255) / 255,
    vec4(73, 40, 121, 255) / 255,
    vec4(42, 31, 61, 255) / 255
);

int bitmap[64] = int[](
    0, 0, 1, 1, 1, 1, 1, 1,
    0, 1, 3, 3, 3, 3, 3, 3,
    1, 3, 3, 2, 2, 2, 2, 2,
    1, 3, 2, 2, 3, 3, 3, 3,
    1, 3, 2, 3, 3, 3, 3, 3,
    1, 3, 2, 3, 3, 3, 3, 3,
    1, 3, 2, 3, 3, 3, 3, 3,
    1, 3, 2, 3, 3, 3, 3, 3
);



void main() {
    vec4 color = vertexColor;
    if (color.a == 0.0) {
        discard;
    }

    fragColor = color * ColorModulator;

    if (flatCorner != vec2(-1))
    {
        //Actual Pos
        vec2 APos1 = Pos1;
        vec2 APos2 = Pos2;
        APos1 = round(APos1 / (flatCorner.x == 0 ? 1 - Coords.z : 1 - Coords.w)); //Right-up corner
        APos2 = round(APos2 / (flatCorner.x == 0 ? Coords.w : Coords.z)); //Left-down corner

        ivec2 res = ivec2(abs(APos1 - APos2)) - 1; //Resolution of frame
        ivec2 stp = ivec2(min(APos1, APos2)); //Left-Up corner
        ivec2 pos = ivec2(floor(position)) - stp; //Position in frame

        vec4 col = vec4(42, 31, 61, 255) / 255.0;
        ivec2 corner = min(pos, res - pos);

        if (corner.x < 8 && corner.y < 8)
        {
            int bit = bitmap[corner.y * 8 + corner.x];
            if (bit == 0)
                discard;
            if (bit != 4)
                col = colors[bit];
        }
        else if (corner.x == 0) // left and right side: Outer
            col = colors[1];
        else if (corner.x == 1) // left and right side: Middle
            col = colors[3];
        else if (corner.x == 2) // left and right side: Inner ish
            col = colors[2];
        else if (corner.y == 0) // top and bottom side: Outer
            col = colors[1];
        else if (corner.y == 1) // top and bottom side: Middle
            col = colors[3];
        else if (corner.y == 2) // top and bottom side: Inner ish
            col = colors[2];

        fragColor = col;
        
    }
}
