/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.common.configuration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import site.siredvin.digitalitems.common.configuration.ConfigHolder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0015\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/digitalitems/common/configuration/ModConfig;", "", "<init>", "()V", "", "getEnableDecay", "()Z", "enableDecay", "", "getDecayTicks", "()J", "decayTicks", "", "getItemStackLimit", "()I", "itemStackLimit", "getFluidStackLimit", "fluidStackLimit", "getEnergyStackLimit", "energyStackLimit", "getInventoryTransferLimit", "inventoryTransferLimit", "CommonConfig", "digitalitems-fabric-1.20.1"})
public final class ModConfig {
    @NotNull
    public static final ModConfig INSTANCE = new ModConfig();

    private ModConfig() {
    }

    public final boolean getEnableDecay() {
        Object object = ConfigHolder.INSTANCE.getCommonConfig().getEnableDecay().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final long getDecayTicks() {
        Object object = ConfigHolder.INSTANCE.getCommonConfig().getDecayTicks().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).longValue();
    }

    public final int getItemStackLimit() {
        Object object = ConfigHolder.INSTANCE.getCommonConfig().getItemStackLimit().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final long getFluidStackLimit() {
        Object object = ConfigHolder.INSTANCE.getCommonConfig().getFluidStackLimit().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).longValue();
    }

    public final long getEnergyStackLimit() {
        Object object = ConfigHolder.INSTANCE.getCommonConfig().getEnergyStackLimit().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).longValue();
    }

    public final int getInventoryTransferLimit() {
        Object object = ConfigHolder.INSTANCE.getCommonConfig().getInventoryTransferLimit().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0018\u0010\u0011R\u0017\u0010\u0019\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u001a\u0010\u0011R\u0017\u0010\u001b\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0014\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lsite/siredvin/digitalitems/common/configuration/ModConfig$CommonConfig;", "", "Lnet/minecraftforge/common/ForgeConfigSpec$Builder;", "builder", "<init>", "(Lnet/minecraftforge/common/ForgeConfigSpec$Builder;)V", "Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;", "enableDecay", "Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;", "getEnableDecay", "()Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;", "setEnableDecay", "(Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;)V", "Lnet/minecraftforge/common/ForgeConfigSpec$LongValue;", "decayTicks", "Lnet/minecraftforge/common/ForgeConfigSpec$LongValue;", "getDecayTicks", "()Lnet/minecraftforge/common/ForgeConfigSpec$LongValue;", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "itemStackLimit", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "getItemStackLimit", "()Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "fluidStackLimit", "getFluidStackLimit", "energyStackLimit", "getEnergyStackLimit", "inventoryTransferLimit", "getInventoryTransferLimit", "digitalitems-fabric-1.20.1"})
    public static final class CommonConfig {
        @NotNull
        private ForgeConfigSpec.BooleanValue enableDecay;
        @NotNull
        private final ForgeConfigSpec.LongValue decayTicks;
        @NotNull
        private final ForgeConfigSpec.IntValue itemStackLimit;
        @NotNull
        private final ForgeConfigSpec.LongValue fluidStackLimit;
        @NotNull
        private final ForgeConfigSpec.LongValue energyStackLimit;
        @NotNull
        private final ForgeConfigSpec.IntValue inventoryTransferLimit;

        public CommonConfig(@NotNull ForgeConfigSpec.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            builder.comment("Item decay options");
            builder.push("decay");
            this.enableDecay = builder.comment("Is item decay enabled").define("enableDecay", true);
            builder.comment("After how many ticks do digital items decay? Default: 120000 (5 in game days)");
            this.decayTicks = builder.defineInRange("decay_ticks", 120000L, 0L, Long.MAX_VALUE);
            this.itemStackLimit = builder.defineInRange("itemStackLimit", 16384, 64, Integer.MAX_VALUE);
            this.fluidStackLimit = builder.defineInRange("fluidStackLimit", 0x3FFFFFFFFFFFFFFFL, 1024L, Long.MAX_VALUE);
            this.energyStackLimit = builder.defineInRange("energyStackLimit", 0x3FFFFFFFFFFFFFFFL, 1024L, Long.MAX_VALUE);
            this.inventoryTransferLimit = builder.defineInRange("inventoryTransferLimit", 1024, 1, Integer.MAX_VALUE);
            builder.pop();
        }

        @NotNull
        public final ForgeConfigSpec.BooleanValue getEnableDecay() {
            return this.enableDecay;
        }

        public final void setEnableDecay(@NotNull ForgeConfigSpec.BooleanValue booleanValue) {
            Intrinsics.checkNotNullParameter((Object)booleanValue, (String)"<set-?>");
            this.enableDecay = booleanValue;
        }

        @NotNull
        public final ForgeConfigSpec.LongValue getDecayTicks() {
            return this.decayTicks;
        }

        @NotNull
        public final ForgeConfigSpec.IntValue getItemStackLimit() {
            return this.itemStackLimit;
        }

        @NotNull
        public final ForgeConfigSpec.LongValue getFluidStackLimit() {
            return this.fluidStackLimit;
        }

        @NotNull
        public final ForgeConfigSpec.LongValue getEnergyStackLimit() {
            return this.energyStackLimit;
        }

        @NotNull
        public final ForgeConfigSpec.IntValue getInventoryTransferLimit() {
            return this.inventoryTransferLimit;
        }
    }
}

