/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.digitalitems.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.broccolium.modules.storage.base.api.SlottedAgnosticStorage;
import site.siredvin.digitalitems.UtilsKt;
import site.siredvin.digitalitems.common.configuration.ModConfig;
import site.siredvin.digitalitems.common.data.ByteArrayWrapper;
import site.siredvin.digitalitems.common.data.DigitalItemsSavedData;
import site.siredvin.digitalitems.common.data.DigitizedEnergyStrategy;
import site.siredvin.digitalitems.common.data.DigitizedFluidStrategy;
import site.siredvin.digitalitems.common.data.DigitizedItemStrategy;
import site.siredvin.digitalitems.common.data.DigitizedSomething;
import site.siredvin.digitalitems.common.data.DigitizedSomethingStrategy;
import site.siredvin.tweakium.modules.peripheral.OwnedPeripheral;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralOwner;
import site.siredvin.tweakium.modules.peripheral.api.IPeripheralPlugin;
import site.siredvin.tweakium.modules.peripheral.owner.BlockEntityPeripheralOwner;
import site.siredvin.tweakium.modules.plugins.InventoryPlugin;
import site.siredvin.tweakium.modules.plugins.SuppliedRudimentInventoryPlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\u0018\u0000 \"*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001\"B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00190\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lsite/siredvin/digitalitems/computercraft/AdvancedDigitizerPeripheral;", "Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;", "T", "Lsite/siredvin/tweakium/modules/peripheral/OwnedPeripheral;", "peripheralOwner", "<init>", "(Lsite/siredvin/tweakium/modules/peripheral/api/IPeripheralOwner;)V", "", "getType", "()Ljava/lang/String;", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "access", "Ldan200/computercraft/api/lua/IArguments;", "arguments", "Ldan200/computercraft/api/lua/MethodResult;", "digitize", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ldan200/computercraft/api/lua/IArguments;)Ldan200/computercraft/api/lua/MethodResult;", "rematerialize", "mode", "Ljava/nio/ByteBuffer;", "id", "", "refresh", "(Ljava/lang/String;Ljava/nio/ByteBuffer;)Z", "", "", "get", "(Ljava/lang/String;Ljava/nio/ByteBuffer;)Ljava/util/Map;", "isEnabled", "()Z", "", "getPeripheralConfiguration", "()Ljava/util/Map;", "peripheralConfiguration", "Companion", "digitalitems-fabric-1.20.1"})
public final class AdvancedDigitizerPeripheral<T extends IPeripheralOwner>
extends OwnedPeripheral<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final SecureRandom rand = new SecureRandom();
    @NotNull
    public static final String TYPE = "advanced_digitizer";
    @NotNull
    private static final class_2960 ID = new class_2960("digitalitems", "advanced_digitizer");
    @NotNull
    private static final Map<String, DigitizedSomethingStrategy<?, ?>> STRATEGIES;

    public AdvancedDigitizerPeripheral(@NotNull T peripheralOwner) {
        Intrinsics.checkNotNullParameter(peripheralOwner, (String)"peripheralOwner");
        super(TYPE, peripheralOwner);
        if (peripheralOwner instanceof BlockEntityPeripheralOwner) {
            class_1937 class_19372 = ((BlockEntityPeripheralOwner)peripheralOwner).getLevel();
            Intrinsics.checkNotNull((Object)class_19372);
            SlottedAgnosticStorage slottedAgnosticStorage = ((BlockEntityPeripheralOwner)peripheralOwner).getStorage();
            Intrinsics.checkNotNull((Object)slottedAgnosticStorage);
            this.addPlugin((IPeripheralPlugin)new InventoryPlugin(class_19372, slottedAgnosticStorage, ModConfig.INSTANCE.getInventoryTransferLimit()));
        } else {
            this.addPlugin((IPeripheralPlugin)new SuppliedRudimentInventoryPlugin(() -> AdvancedDigitizerPeripheral._init_$lambda$0(peripheralOwner), () -> AdvancedDigitizerPeripheral._init_$lambda$1(peripheralOwner)));
        }
    }

    public boolean isEnabled() {
        return true;
    }

    @NotNull
    public String getType() {
        return TYPE;
    }

    @NotNull
    public Map<String, Object> getPeripheralConfiguration() {
        Map base = super.getPeripheralConfiguration();
        base.put("decayEnabled", ModConfig.INSTANCE.getEnableDecay());
        base.put("decayTicks", ModConfig.INSTANCE.getDecayTicks());
        base.put("itemStackLimit", ModConfig.INSTANCE.getItemStackLimit());
        base.put("fluidStackLimit", ModConfig.INSTANCE.getFluidStackLimit());
        base.put("energyStackLimit", ModConfig.INSTANCE.getEnergyStackLimit());
        return base;
    }

    /*
     * Enabled aggressive block sorting
     */
    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult digitize(@NotNull IComputerAccess access, @NotNull IArguments arguments) throws LuaException {
        ByteArrayWrapper byteArrayWrapper;
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String mode = arguments.getString(0);
        Optional optional = arguments.optString(1);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"optString(...)");
        String source = (String)OptionalsKt.getOrDefault((Optional)optional, (Object)"self");
        Object filter = arguments.get(2);
        Optional optional2 = arguments.optLong(3);
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"optLong(...)");
        Long limit = (Long)OptionalsKt.getOrNull((Optional)optional2);
        Optional optional3 = arguments.optBytes(4);
        Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"optBytes(...)");
        ByteBuffer destination = (ByteBuffer)OptionalsKt.getOrNull((Optional)optional3);
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy = STRATEGIES.get(mode);
        if (digitizedSomethingStrategy == null) {
            throw new LuaException("There is no such mode");
        }
        DigitizedSomethingStrategy<?, ?> strategy = digitizedSomethingStrategy;
        if (limit != null) {
            UtilsKt.assertBetween(limit, 1L, strategy.getLimitLimit(), "limit");
        }
        Intrinsics.checkNotNull((Object)source);
        Object object = destination;
        if (object != null) {
            byte[] byArray = UtilsKt.toSafeArray((ByteBuffer)object);
            object = byArray;
            if (byArray != null) {
                byteArrayWrapper = UtilsKt.wrap((byte[])object);
                return strategy.digitize(access, source, filter, limit, byteArrayWrapper, this.getPeripheralOwner());
            }
        }
        byteArrayWrapper = null;
        return strategy.digitize(access, source, filter, limit, byteArrayWrapper, this.getPeripheralOwner());
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult rematerialize(@NotNull IComputerAccess access, @NotNull IArguments arguments) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String mode = arguments.getString(0);
        ByteBuffer id = arguments.getBytes(1);
        Optional optional = arguments.optLong(2);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"optLong(...)");
        Long limit = (Long)OptionalsKt.getOrNull((Optional)optional);
        Optional optional2 = arguments.optString(3);
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"optString(...)");
        String destination = (String)OptionalsKt.getOrDefault((Optional)optional2, (Object)"self");
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy = STRATEGIES.get(mode);
        if (digitizedSomethingStrategy == null) {
            throw new LuaException("There is no such mode");
        }
        DigitizedSomethingStrategy<?, ?> strategy = digitizedSomethingStrategy;
        if (limit != null) {
            UtilsKt.assertBetween(limit, 1L, strategy.getLimitLimit(), "limit");
        }
        Intrinsics.checkNotNull((Object)id);
        ByteArrayWrapper byteArrayWrapper = UtilsKt.wrap(UtilsKt.toSafeArray(id));
        Intrinsics.checkNotNull((Object)destination);
        return strategy.rematerialize(access, byteArrayWrapper, limit, destination, this.getPeripheralOwner());
    }

    @LuaFunction(mainThread=true)
    public final boolean refresh(@NotNull String mode, @NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy = STRATEGIES.get(mode);
        if (digitizedSomethingStrategy == null) {
            throw new LuaException("There is no such mode");
        }
        DigitizedSomethingStrategy<?, ?> strategy = digitizedSomethingStrategy;
        ByteArrayWrapper byteArrayWrapper = UtilsKt.wrap(UtilsKt.toSafeArray(id));
        class_1937 class_19372 = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)class_19372);
        return strategy.refresh(byteArrayWrapper, class_19372);
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, Object> get(@NotNull String mode, @NotNull ByteBuffer id) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy = STRATEGIES.get(mode);
        DigitizedSomethingStrategy<?, ?> digitizedSomethingStrategy2 = digitizedSomethingStrategy instanceof DigitizedSomethingStrategy ? digitizedSomethingStrategy : null;
        if (digitizedSomethingStrategy2 == null) {
            throw new LuaException("There is no such mode");
        }
        DigitizedSomethingStrategy<?, ?> strategy = digitizedSomethingStrategy2;
        class_1937 class_19372 = this.getPeripheralOwner().getLevel();
        Intrinsics.checkNotNull((Object)class_19372);
        class_1937 level = class_19372;
        DigitalItemsSavedData sd = DigitalItemsSavedData.Companion.getFrom(level);
        Object obj = strategy.getById(UtilsKt.wrap(UtilsKt.toSafeArray(id)), sd, level);
        if (obj == null) {
            return null;
        }
        Object something = obj;
        return strategy.represent((DigitizedSomething<?>)something, level);
    }

    private static final class_1937 _init_$lambda$0(IPeripheralOwner $peripheralOwner) {
        Intrinsics.checkNotNullParameter((Object)$peripheralOwner, (String)"$peripheralOwner");
        class_1937 class_19372 = $peripheralOwner.getLevel();
        Intrinsics.checkNotNull((Object)class_19372);
        return class_19372;
    }

    private static final SlottedAgnosticStorage _init_$lambda$1(IPeripheralOwner $peripheralOwner) {
        Intrinsics.checkNotNullParameter((Object)$peripheralOwner, (String)"$peripheralOwner");
        SlottedAgnosticStorage slottedAgnosticStorage = $peripheralOwner.getStorage();
        Intrinsics.checkNotNull((Object)slottedAgnosticStorage);
        return slottedAgnosticStorage;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"item", (Object)new DigitizedItemStrategy()), TuplesKt.to((Object)"fluid", (Object)new DigitizedFluidStrategy()), TuplesKt.to((Object)"energy", (Object)new DigitizedEnergyStrategy())};
        STRATEGIES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R+\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/digitalitems/computercraft/AdvancedDigitizerPeripheral$Companion;", "", "<init>", "()V", "Ljava/security/SecureRandom;", "rand", "Ljava/security/SecureRandom;", "getRand", "()Ljava/security/SecureRandom;", "", "TYPE", "Ljava/lang/String;", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "", "Lsite/siredvin/digitalitems/common/data/DigitizedSomethingStrategy;", "STRATEGIES", "Ljava/util/Map;", "getSTRATEGIES", "()Ljava/util/Map;", "digitalitems-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecureRandom getRand() {
            return rand;
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        @NotNull
        public final Map<String, DigitizedSomethingStrategy<?, ?>> getSTRATEGIES() {
            return STRATEGIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

